/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;

public class DirectusNotifier {
    private static final Logger LOGGER = Logger.getLogger(DirectusNotifier.class);
    private final CloseableHttpClient httpClient;
    private final DirectusConnectionConfig connectionConfig;
    private final ObjectMapper objectMapper;

    public DirectusNotifier(CloseableHttpClient httpClient, DirectusConnectionConfig connectionConfig) {
        this.httpClient = httpClient;
        this.connectionConfig = connectionConfig;
        this.objectMapper = new ObjectMapper();
    }

    public void notifyCreate(UserRoleDto data) throws IOException {
        HttpPost request = new HttpPost();
        request.setURI(URI.create(this.connectionConfig.url() + "/users"));
        request.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        this.httpClient.execute((HttpUriRequest)request, response -> {
            int responseCode = response.getStatusLine().getStatusCode();
            try (InputStream stream = response.getEntity().getContent();){
                String responseBody = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (DirectusNotifier.isSuccessful(responseCode)) {
                    throw new IOException("Unable to create new user on Directus: " + responseBody);
                }
                LOGGER.info((Object)("Successfully created new user on Directus: " + responseBody));
            }
            return Void.class;
        });
    }

    private static boolean isSuccessful(int responseCode) {
        return responseCode < 200 || responseCode > 299;
    }
}

