/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class UserRoleUtils {
    private static final Logger LOGGER = Logger.getLogger(UserRoleUtils.class);

    public static Set<RoleModel> extractUserRoles(UserModel user) {
        HashSet<RoleModel> userRoles = new HashSet<RoleModel>();
        user.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
            LOGGER.info((Object)String.format("User '%s' has non-composite role '%s'", user.getEmail(), role.getName()));
            userRoles.add((RoleModel)role);
        });
        user.getGroupsStream().forEach(group -> {
            LOGGER.info((Object)String.format("User '%s' has group '%s'", user.getEmail(), group.getName()));
            group.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
                LOGGER.info((Object)String.format("Group '%s' has non-composite role '%s'", group.getName(), role.getName()));
                userRoles.add((RoleModel)role);
            });
        });
        return userRoles;
    }

    public static boolean roleNameMatches(Collection<RoleModel> userRoles, DirectusConnectionConfig.RoleConfig roleConfig) {
        boolean areUserRolesEmpty;
        boolean bl = areUserRolesEmpty = userRoles == null || userRoles.isEmpty();
        if (roleConfig == null) {
            return areUserRolesEmpty;
        }
        return areUserRolesEmpty || userRoles.stream().map(RoleModel::getName).anyMatch(roleName -> roleName.equalsIgnoreCase(roleConfig.name()));
    }
}

