/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import ch.iterial.keycloak.plugins.directus.UserRoleUtils;
import java.util.Arrays;
import java.util.Set;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserRoleService {
    private final DirectusConnectionConfig connectionConfig;
    private final KeycloakSessionFactory keycloakSessionFactory;

    public UserRoleService(DirectusConnectionConfig connectionConfig, KeycloakSessionFactory keycloakSessionFactory) {
        this.connectionConfig = connectionConfig;
        this.keycloakSessionFactory = keycloakSessionFactory;
    }

    public UserRoleDto getUser(AdminEvent event) {
        String userId = this.getUserId(event);
        return (UserRoleDto)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.keycloakSessionFactory, session -> {
            RealmModel userRealm = session.realms().getRealm(event.getRealmId());
            UserModel user = session.users().getUserById(userRealm, userId);
            String configProviderName = this.connectionConfig.provider();
            if (user == null) {
                return new UserRoleDto(null, userId, null, null, null, "active", configProviderName, null);
            }
            Set<RoleModel> userRoles = UserRoleUtils.extractUserRoles(user);
            DirectusConnectionConfig.RoleConfig[] roleConfigs = this.connectionConfig.roles();
            return new UserRoleDto(null, user.getId(), user.getFirstName(), user.getLastName(), user.getEmail(), "active", configProviderName, Arrays.stream(roleConfigs).filter(roleConfig -> UserRoleUtils.roleNameMatches(userRoles, roleConfig)).findFirst().map(DirectusConnectionConfig.RoleConfig::directusId).orElse(null));
        });
    }

    private String getUserId(AdminEvent event) {
        String[] userIdTokens;
        if (!this.connectionConfig.valid()) {
            throw new IllegalStateException("Connection config is not valid");
        }
        String userPath = event.getResourcePath();
        String[] stringArray = userIdTokens = userPath == null || userPath.trim().isEmpty() ? new String[]{} : userPath.split("/");
        if (userIdTokens.length < 2 || !userIdTokens[0].equalsIgnoreCase("users")) {
            throw new IllegalArgumentException("Invalid user resource path: " + userPath);
        }
        return userIdTokens[1];
    }
}

