/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.DirectusNotifier;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import ch.iterial.keycloak.plugins.directus.UserRoleService;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerTransaction;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class DirectusEventListenerProvider
implements EventListenerProvider {
    private static final Logger LOGGER = Logger.getLogger(DirectusEventListenerProvider.class);
    private final DirectusNotifier directusNotifier;
    private final UserRoleService userRoleService;
    private final DirectusConnectionConfig connectionConfig;
    private final EventListenerTransaction eventTransaction;

    public DirectusEventListenerProvider(DirectusNotifier directusNotifier, UserRoleService userRoleService, DirectusConnectionConfig connectionConfig, KeycloakSession keycloakSession) {
        this.directusNotifier = directusNotifier;
        this.userRoleService = userRoleService;
        this.connectionConfig = connectionConfig;
        this.eventTransaction = new EventListenerTransaction(this::sendAdminEvent, this::sendEvent);
        if (connectionConfig.valid()) {
            keycloakSession.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.eventTransaction);
        }
        LOGGER.debug((Object)"Created provider");
    }

    public void onEvent(Event event) {
        LOGGER.debug((Object)String.format("Provider handling event '%s': %s", event.getType(), event.getUserId()));
        if (this.connectionConfig.valid()) {
            this.eventTransaction.addEvent(event);
        }
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        LOGGER.debug((Object)String.format("Provider handling admin event with representation '%s': %s", includeRepresentation, event.getOperationType()));
        if (this.connectionConfig.valid()) {
            this.eventTransaction.addAdminEvent(event, includeRepresentation);
        }
    }

    public void close() {
        LOGGER.debug((Object)"Closing provider");
    }

    private void sendEvent(Event event) {
        LOGGER.debug((Object)String.format("Provider sending event '%s': %s", event.getType(), event.getUserId()));
        if (this.realmFilterPasses(event) && this.resourceFilterPasses(event)) {
            try {
                UserRoleDto dto = this.userRoleService.getUser(event);
                LOGGER.info((Object)String.format("Notifying Directus about the user event: %s", dto));
                switch (event.getType()) {
                    case REGISTER: {
                        this.createOnDirectus(dto);
                        break;
                    }
                    default: {
                        LOGGER.warn((Object)("Unsupported event type: " + String.valueOf(event.getType())));
                        break;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to notify Directus about the user event", (Throwable)e);
            }
        }
    }

    private void sendAdminEvent(AdminEvent event, boolean includeRepresentation) {
        LOGGER.debug((Object)String.format("Provider sending admin event with representation '%s'. Realm ID: %s. Operation: %s. Resource: %s.", includeRepresentation, event.getRealmName(), event.getOperationType(), String.valueOf(event.getResourceType()) + " " + event.getResourcePath()));
        if (this.realmFilterPasses(event) && this.resourceFilterPasses(event)) {
            try {
                UserRoleDto dto = this.userRoleService.getUser(event);
                LOGGER.info((Object)String.format("Notifying Directus about the user admin event: %s", dto));
                switch (event.getOperationType()) {
                    case CREATE: {
                        this.createOnDirectus(dto);
                        break;
                    }
                    case UPDATE: {
                        this.updateOnDirectus(dto);
                        break;
                    }
                    default: {
                        LOGGER.warn((Object)("Unsupported operation type: " + String.valueOf(event.getOperationType())));
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to notify Directus about the user change", (Throwable)e);
            }
        }
    }

    private boolean realmFilterPasses(AdminEvent event) {
        return this.connectionConfig.realm() == null || this.connectionConfig.realm().equalsIgnoreCase(event.getRealmName());
    }

    private boolean realmFilterPasses(Event event) {
        return this.connectionConfig.realm() == null || this.connectionConfig.realm().equalsIgnoreCase(event.getRealmName());
    }

    private boolean resourceFilterPasses(AdminEvent event) {
        return ResourceType.USER.equals((Object)event.getResourceType()) && (this.connectionConfig.sync() == null || OperationType.CREATE.equals((Object)event.getOperationType()) && this.connectionConfig.sync().create() || OperationType.UPDATE.equals((Object)event.getOperationType()) && this.connectionConfig.sync().update() || OperationType.DELETE.equals((Object)event.getOperationType()) && this.connectionConfig.sync().delete());
    }

    private boolean resourceFilterPasses(Event event) {
        return EventType.REGISTER.equals((Object)event.getType()) && (this.connectionConfig.sync() == null || this.connectionConfig.sync().create());
    }

    private void createOnDirectus(UserRoleDto dto) throws IOException {
        UserRoleDto existing = this.directusNotifier.getUserByEmail(dto.email());
        if (existing == null) {
            this.directusNotifier.notifyUserCreated(dto);
            LOGGER.info((Object)("Notified Directus about new user creation: " + dto.email()));
        } else {
            LOGGER.warn((Object)("User already exists in Directus with email: " + dto.email()));
            this.directusNotifier.notifyUserUpdated(existing.id(), dto);
            LOGGER.info((Object)"Notified Directus about the user creation with upsert");
        }
    }

    private void updateOnDirectus(UserRoleDto dto) throws IOException {
        UserRoleDto existing = this.directusNotifier.getUserByEmail(dto.email());
        if (existing == null) {
            LOGGER.warn((Object)("User not found in Directus with email: " + dto.email()));
            this.directusNotifier.notifyUserCreated(dto);
            LOGGER.info((Object)"Notified Directus about the user modification with upsert");
        } else {
            this.directusNotifier.notifyUserUpdated(existing.id(), dto);
            LOGGER.info((Object)("Notified Directus about the user modification with update: " + dto.email()));
        }
    }
}

