/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import ch.iterial.keycloak.plugins.directus.UserRoleListDto;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;

public class DirectusNotifier {
    private static final Logger LOGGER = Logger.getLogger(DirectusNotifier.class);
    private final CloseableHttpClient httpClient;
    private final DirectusConnectionConfig connectionConfig;
    private final ObjectMapper objectMapper;

    public DirectusNotifier(CloseableHttpClient httpClient, DirectusConnectionConfig connectionConfig) {
        this.httpClient = httpClient;
        this.connectionConfig = connectionConfig;
        this.objectMapper = new ObjectMapper();
    }

    public void notifyUserCreated(UserRoleDto data) throws IOException {
        HttpPost request = new HttpPost();
        request.setURI(URI.create(this.connectionConfig.url() + "/users"));
        request.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        this.notify((HttpEntityEnclosingRequestBase)request);
    }

    public void notifyUserUpdated(String id, UserRoleDto updated) throws IOException {
        UserRoleDto patch = new UserRoleDto(null, updated.userId(), updated.firstName(), updated.lastName(), null, null, null, updated.roleId());
        HttpPatch request = new HttpPatch();
        request.setURI(URI.create(this.connectionConfig.url() + "/users/" + id));
        request.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)patch), ContentType.APPLICATION_JSON));
        this.notify((HttpEntityEnclosingRequestBase)request);
    }

    private void notify(HttpEntityEnclosingRequestBase request) throws IOException {
        this.httpClient.execute((HttpUriRequest)request, response -> {
            int responseCode = response.getStatusLine().getStatusCode();
            try (InputStream stream = response.getEntity().getContent();){
                String responseBody = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (DirectusNotifier.isUnsuccessful(responseCode)) {
                    throw new IOException(String.format("Unable to send %s request to Directus: %s", request.getMethod(), responseBody));
                }
                LOGGER.info((Object)String.format("Successfully sent %s request to Directus: %s", request.getMethod(), responseBody));
            }
            return Void.class;
        });
    }

    public UserRoleDto getUserByEmail(String email) throws IOException {
        HttpGet request = new HttpGet();
        request.setURI(URI.create(this.connectionConfig.url() + "/users?filter[email][_eq]=" + email));
        return (UserRoleDto)this.httpClient.execute((HttpUriRequest)request, response -> {
            int responseCode = response.getStatusLine().getStatusCode();
            try (InputStream stream = response.getEntity().getContent();){
                if (DirectusNotifier.isUnsuccessful(responseCode)) {
                    String error = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    throw new IOException("Unable to create new user on Directus: " + error);
                }
                UserRoleListDto results = (UserRoleListDto)this.objectMapper.readValue(stream, (TypeReference)new TypeReference<UserRoleListDto>(){});
                if (results != null && results.data() != null && results.data().length > 0) {
                    UserRoleDto result = results.data()[0];
                    LOGGER.info((Object)("Successfully retrieved user from Directus: " + String.valueOf(result)));
                    UserRoleDto userRoleDto = result;
                    return userRoleDto;
                }
            }
            return null;
        });
    }

    private static boolean isUnsuccessful(int responseCode) {
        return responseCode < 200 || responseCode > 299;
    }
}

