/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics;

import ch.javacamp.metrics.ClassInfo;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class DependencyAnalyzer {
    public static ClassInfo getDependentClasses(ClassReader classReader) throws IOException {
        final HashSet<String> dependentClasses = new HashSet<String>();
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        String ownName = classNode.name.replace("/", ".");
        DependencyAnalyzer.extractSuperclassAndInterfaces(classNode, dependentClasses);
        for (FieldNode field : classNode.fields) {
            Type type = Type.getType((String)field.desc);
            DependencyAnalyzer.addType(dependentClasses, type);
        }
        for (MethodNode method : classNode.methods) {
            Type returnType = Type.getReturnType((String)method.desc);
            DependencyAnalyzer.addType(dependentClasses, returnType);
            Type[] argumentTypes = Type.getArgumentTypes((String)method.desc);
            for (Type argType : argumentTypes) {
                DependencyAnalyzer.addType(dependentClasses, argType);
            }
            if (method.localVariables != null) {
                for (LocalVariableNode localVar : method.localVariables) {
                    Type localVarType = Type.getType((String)localVar.desc);
                    DependencyAnalyzer.addType(dependentClasses, localVarType);
                }
            }
            if (method.instructions == null) continue;
            for (AbstractInsnNode instr : method.instructions) {
                instr.accept(new MethodVisitor(589824){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        dependentClasses.add(owner.replace("/", "."));
                    }
                });
            }
        }
        boolean isInterface = (classNode.access & 0x200) != 0;
        boolean isAbstract = (classNode.access & 0x400) != 0;
        return new ClassInfo(ownName, isInterface || isAbstract, dependentClasses);
    }

    private static void extractSuperclassAndInterfaces(ClassNode classNode, Set<String> dependentClasses) {
        if (classNode.superName != null) {
            dependentClasses.add(classNode.superName.replace('/', '.'));
        }
        for (String interfaceName : classNode.interfaces) {
            dependentClasses.add(interfaceName.replace('/', '.'));
        }
    }

    private static void addType(Set<String> dependentClasses, Type type) {
        if (type.getSort() == 10) {
            dependentClasses.add(type.getClassName());
        } else if (type.getSort() == 9) {
            DependencyAnalyzer.addType(dependentClasses, type.getElementType());
        }
    }

    public static void main(String[] args) throws IOException {
        String className = DependencyAnalyzer.class.getName();
        ClassReader classReader = new ClassReader(className);
        ClassInfo result = DependencyAnalyzer.getDependentClasses(classReader);
        System.out.println("Dependent classes:");
        for (String depClass : result.dependencies()) {
            System.out.println(depClass);
        }
    }
}

