/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics;

import ch.javacamp.metrics.ClassInfo;
import ch.javacamp.metrics.DependencyAnalyzer;
import ch.javacamp.metrics.ModuleCollector;
import ch.javacamp.metrics.ModuleInfo;
import ch.javacamp.metrics.ModuleProcessingState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.ClassReader;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.PRE_SITE)
public class MetricsMojo
extends AbstractMojo {
    private final MavenProject project;
    private final ModuleCollector moduleCollector;
    private final ModuleProcessingState processingState;

    @Inject
    public MetricsMojo(MavenProject project, ModuleCollector collector, ModuleProcessingState procssingState) {
        this.project = project;
        this.moduleCollector = collector;
        this.processingState = procssingState;
    }

    private static ClassInfo analyzeClass(File f) {
        try {
            ClassReader reader = new ClassReader((InputStream)new FileInputStream(f));
            return DependencyAnalyzer.getDependentClasses(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isClassFile(File f) {
        return f.getName().endsWith(".class");
    }

    public void execute() throws MojoExecutionException {
        this.project.getModules().forEach(this.processingState::addDetectedModule);
        this.processingState.addProcessedModule(this.project.getArtifactId());
        this.processClasses(this.project.getBuild().getOutputDirectory());
        if (this.processingState.allModulesProcessed()) {
            this.compute();
        }
    }

    private void compute() {
        this.getLog().info((CharSequence)"Computation");
        for (ModuleInfo currentModule : this.moduleCollector.getModules()) {
            Set<String> moduleClasses = currentModule.allClasses();
            Set<ModuleInfo> otherModules = this.moduleCollector.otherModules(currentModule);
            long outsideClassesWithDependenciesToMe = otherModules.stream().flatMap(x -> x.classes().stream()).filter(c -> c.hasDependency(moduleClasses)).count();
            int classesWithForeignDependencies = 0;
            Set allOtherClasses = otherModules.stream().flatMap(x -> x.classes().stream()).map(ClassInfo::className).collect(Collectors.toSet());
            block1: for (ClassInfo c2 : currentModule.classes()) {
                for (String dep : c2.dependencies()) {
                    if (!allOtherClasses.contains(dep)) continue;
                    ++classesWithForeignDependencies;
                    continue block1;
                }
            }
            this.getLog().info((CharSequence)currentModule.name());
            this.getLog().info((CharSequence)(" A: " + currentModule.abstractness()));
            this.getLog().info((CharSequence)("Ca: " + outsideClassesWithDependenciesToMe));
            this.getLog().info((CharSequence)("Ce: " + classesWithForeignDependencies));
            long ca = outsideClassesWithDependenciesToMe;
            int ce = classesWithForeignDependencies;
            double i = (double)ce / (double)((long)ce + ca);
            this.getLog().info((CharSequence)(" I: " + i));
            double a = currentModule.abstractness();
            this.getLog().info((CharSequence)(" D: " + Math.abs((a + i - 1.0) / 2.0)));
        }
    }

    private void processClasses(String classesDirectory) {
        HashSet<ClassInfo> s = new HashSet<ClassInfo>();
        Path base = Path.of(classesDirectory, new String[0]);
        if (base.toFile().exists()) {
            try (Stream<Path> files = Files.walk(base, FileVisitOption.FOLLOW_LINKS);){
                files.map(Path::toFile).filter(MetricsMojo::isClassFile).map(MetricsMojo::analyzeClass).forEach(s::add);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!s.isEmpty()) {
            this.moduleCollector.addModule(new ModuleInfo(this.project.getArtifactId(), s));
        }
    }
}

