/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics;

import ch.javacamp.metrics.ClassDescriptor;
import ch.javacamp.metrics.MetricsResult;
import ch.javacamp.metrics.ModuleDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class Modules {
    private final List<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();

    public void addModule(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor.totalClasses() > 0L) {
            this.modules.add(moduleDescriptor);
        }
    }

    public List<ModuleDescriptor> getModules() {
        return this.modules;
    }

    public Set<ModuleDescriptor> otherModules(ModuleDescriptor toExclude) {
        return this.modules.stream().filter(x -> x != toExclude).collect(Collectors.toSet());
    }

    public Set<ClassDescriptor> externalClassesUsingClassesInThisModule(ModuleDescriptor module) {
        Set<String> classNamesCurrentModule = module.allClassNames();
        Set<ModuleDescriptor> otherModules = this.otherModules(module);
        return otherModules.stream().flatMap(x -> x.classes().stream()).filter(c -> c.hasDependency(classNamesCurrentModule)).collect(Collectors.toSet());
    }

    public Set<ClassDescriptor> externalClassesUsedByThisModule(ModuleDescriptor module) {
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        Set allClassNamesOutsideCurrentModule = this.otherModules(module).stream().flatMap(x -> x.classes().stream()).map(ClassDescriptor::className).collect(Collectors.toSet());
        for (ClassDescriptor classDescriptor : module.classes()) {
            for (String dependency : classDescriptor.dependencies()) {
                if (!allClassNamesOutsideCurrentModule.contains(dependency)) continue;
                result.add(classDescriptor);
            }
        }
        return result;
    }

    public MetricsResult computeMetrics(ModuleDescriptor module) {
        Set<ClassDescriptor> outsideClassesWithDependenciesToMe = this.externalClassesUsingClassesInThisModule(module);
        Set<ClassDescriptor> classesWithForeignDependencies = this.externalClassesUsedByThisModule(module);
        int ca = outsideClassesWithDependenciesToMe.size();
        int ce = classesWithForeignDependencies.size();
        double i = (double)ce / (double)(ce + ca);
        double a = module.abstractness();
        double d = Math.abs((a + i - 1.0) / 2.0);
        return new MetricsResult(module.name(), module.totalClasses(), ca, ce, a, i, d);
    }

    public List<MetricsResult> computeMetrics() {
        ArrayList<MetricsResult> result = new ArrayList<MetricsResult>();
        for (ModuleDescriptor currentModule : this.getModules()) {
            result.add(this.computeMetrics(currentModule));
        }
        return result;
    }
}

