/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics;

import ch.javacamp.metrics.ModuleProcessingState;
import ch.javacamp.metrics.analyzer.ClassAnalyzer;
import ch.javacamp.metrics.core.ClassDescriptor;
import ch.javacamp.metrics.core.MetricsResult;
import ch.javacamp.metrics.core.ModuleDescriptor;
import ch.javacamp.metrics.core.Modules;
import ch.javacamp.metrics.rendering.Renderer;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.fusesource.jansi.Ansi;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.PRE_SITE)
public class MetricsMojo
extends AbstractMojo {
    private final MavenProject project;
    private final Modules modules;
    private final ModuleProcessingState processingState;
    private final ClassAnalyzer classAnalyzer;
    private final Renderer renderer;

    @Inject
    public MetricsMojo(MavenProject project, Modules collector, ModuleProcessingState processingState, ClassAnalyzer classAnalyzer, Renderer renderer) {
        this.project = project;
        this.modules = collector;
        this.processingState = processingState;
        this.classAnalyzer = classAnalyzer;
        this.renderer = renderer;
    }

    public void execute() {
        this.project.getModules().forEach(this.processingState::addDetectedModule);
        this.processingState.addProcessedModule(this.project.getArtifactId());
        Set<ClassDescriptor> classes = this.classAnalyzer.processClasses(Path.of(this.project.getBuild().getOutputDirectory(), new String[0]));
        this.modules.addModule(new ModuleDescriptor(this.project.getArtifactId(), classes));
        if (this.processingState.allModulesProcessed()) {
            this.logReport();
            this.renderReport();
        }
    }

    private void logReport() {
        this.getLog().info((CharSequence)Ansi.ansi().bold().render("Computation").reset().toString());
        for (MetricsResult result : this.modules.computeMetrics()) {
            this.getLog().info((CharSequence)Ansi.ansi().fgGreen().bold().render(result.name()).reset().toString());
            this.getLog().info((CharSequence)(" A: " + result.abstractness()));
            this.getLog().info((CharSequence)("Ca: " + result.ca()));
            this.getLog().info((CharSequence)("Ce: " + result.ce()));
            this.getLog().info((CharSequence)(" I: " + result.instability()));
            this.getLog().info((CharSequence)(" D: " + result.distance()));
        }
    }

    private void renderReport() {
        MavenProject parentProject = this.project;
        while (parentProject.getParent() != null) {
            parentProject = parentProject.getParent();
        }
        File targetDir = new File(parentProject.getBasedir(), "target");
        if (targetDir.exists() || targetDir.mkdir()) {
            this.renderer.render(targetDir.toPath().resolve("oo-metrics-report.html"), this.modules.computeMetrics());
        }
    }
}

