/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.analyzer;

import ch.javacamp.metrics.analyzer.CohesionAnalyzer;
import ch.javacamp.metrics.analyzer.DependencyAnalyzer;
import ch.javacamp.metrics.core.ClassDescriptor;
import ch.javacamp.metrics.core.MethodDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;

public class ClassAnalyzer {
    public Set<ClassDescriptor> processClasses(Path directory) {
        if (directory.toFile().exists()) {
            Set<ClassDescriptor> set;
            block9: {
                Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);
                try {
                    set = files.map(Path::toFile).filter(this::isClassFile).map(this::analyzeClass).collect(Collectors.toSet());
                    if (files == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                files.close();
            }
            return set;
        }
        return new HashSet<ClassDescriptor>();
    }

    private boolean isClassFile(File f) {
        return f.getName().endsWith(".class");
    }

    private ClassDescriptor analyzeClass(File f) {
        try {
            ClassReader reader = new ClassReader((InputStream)new FileInputStream(f));
            return this.analyze(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassDescriptor analyze(ClassReader reader) throws IOException {
        ClassDescriptor classes = new DependencyAnalyzer().analyze(reader);
        Set<MethodDescriptor> methods = new CohesionAnalyzer().analyze(reader);
        classes.addMethods(methods);
        return classes;
    }
}

