/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.analyzer;

import ch.javacamp.metrics.core.ClassDescriptor;
import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.Visibility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DependencyAnalyzer {
    public ClassDescriptor analyze(ClassReader classReader) {
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        HashSet<String> dependentClasses = new HashSet<String>();
        dependentClasses.addAll(this.extractSuperclassAndInterfaces(classNode));
        dependentClasses.addAll(this.extractFields(classNode));
        for (MethodNode method : classNode.methods) {
            dependentClasses.addAll(this.extractExceptionTypes(method));
            this.extractReturnType(method).ifPresent(dependentClasses::add);
            dependentClasses.addAll(this.extractMethodArguments(method));
            dependentClasses.addAll(this.extractLocalVariable(method));
            dependentClasses.addAll(this.extractMethodInstructionTypes(method));
        }
        String ownName = this.transformClassName(classNode.name);
        dependentClasses.remove(ownName);
        Visibility visibility = Visibility.parse(classNode.access);
        return new ClassDescriptor(ownName, this.isAbstract(classNode), visibility, dependentClasses, new HashSet<MethodDescriptor>());
    }

    private Set<String> extractExceptionTypes(MethodNode method) {
        if (method.exceptions == null) {
            return Set.of();
        }
        return method.exceptions.stream().map(this::transformClassName).collect(Collectors.toSet());
    }

    private Set<String> extractMethodInstructionTypes(MethodNode method) {
        if (method.instructions == null) {
            return Set.of();
        }
        final HashSet<String> dependentClasses = new HashSet<String>();
        for (AbstractInsnNode instr : method.instructions) {
            instr.accept(new MethodVisitor(589824){

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    dependentClasses.add(DependencyAnalyzer.this.transformClassName(owner));
                }
            });
        }
        return dependentClasses;
    }

    private Set<String> extractLocalVariable(MethodNode method) {
        if (method.localVariables == null) {
            return Set.of();
        }
        return method.localVariables.stream().map(l -> l.desc).map(Type::getType).map(this::addType).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Set<String> extractMethodArguments(MethodNode method) {
        return Arrays.stream(Type.getArgumentTypes((String)method.desc)).map(this::addType).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<String> extractReturnType(MethodNode method) {
        return this.addType(Type.getReturnType((String)method.desc));
    }

    private Set<String> extractFields(ClassNode classNode) {
        return classNode.fields.stream().map(field -> Type.getType((String)field.desc)).map(this::addType).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Set<String> extractSuperclassAndInterfaces(ClassNode classNode) {
        HashSet<String> dependentClasses = new HashSet<String>();
        if (classNode.superName != null) {
            dependentClasses.add(this.transformClassName(classNode.superName));
        }
        for (String interfaceName : classNode.interfaces) {
            dependentClasses.add(this.transformClassName(interfaceName));
        }
        return dependentClasses;
    }

    private Optional<String> addType(Type type) {
        if (type.getSort() == 10) {
            return Optional.of(type.getClassName());
        }
        if (type.getSort() == 9) {
            return this.addType(type.getElementType());
        }
        return Optional.empty();
    }

    private boolean isAbstract(ClassNode classNode) {
        boolean isInterface = (classNode.access & 0x200) != 0;
        boolean isAbstractClass = (classNode.access & 0x400) != 0;
        return isAbstractClass || isInterface;
    }

    private String transformClassName(String c) {
        return c.replace("/", ".");
    }
}

