/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.Relation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class LCOM4Calculator {
    LCOM4Calculator() {
    }

    public int calculate(Set<MethodDescriptor> methodDescriptors) {
        HashSet<Group> groups = new HashSet<Group>();
        for (MethodDescriptor method : methodDescriptors) {
            Set<String> methodNames = Relation.combine(Set.of(method.getShortName()), method.getInvokedLocalMethods());
            Set<String> fieldNames = Relation.combine(method.getReadFields(), method.getWrittenFields());
            groups.add(Group.create(fieldNames, methodNames));
        }
        boolean tryHarder = true;
        block1: while (tryHarder) {
            tryHarder = false;
            ArrayList localGroups = new ArrayList(groups);
            for (Group g1 : localGroups) {
                for (Group g2 : localGroups) {
                    if (g1 == g2 || !g1.intersect(g2)) continue;
                    tryHarder = true;
                    groups.remove(g2);
                    continue block1;
                }
            }
        }
        return groups.size();
    }

    static class Group {
        Set<String> fields;
        Set<String> methods;

        private Group(Set<String> fields, Set<String> methods) {
            Objects.requireNonNull(fields);
            Objects.requireNonNull(methods);
            this.fields = fields;
            this.methods = methods;
        }

        public static Group create(Set<String> fields, Set<String> methods) {
            return new Group(fields, methods);
        }

        public boolean hasCommonField(Set<String> otherFields) {
            return Relation.containsAtLeastOneElement(this.fields, otherFields);
        }

        public boolean isConnected(Set<String> otherMethods) {
            return Relation.containsAtLeastOneElement(this.methods, otherMethods);
        }

        public boolean intersect(Group other) {
            if (this.hasCommonField(other.fields) || this.isConnected(other.methods)) {
                this.fields.addAll(other.fields);
                this.methods.addAll(other.methods);
                return true;
            }
            return false;
        }
    }
}

