/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.Relation;
import ch.javacamp.metrics.core.Visibility;
import java.util.HashSet;
import java.util.Set;

public class MethodDescriptor {
    private static final Set<String> SPECIAL_METHODS = Set.of("equals(java.lang.Object):boolean", "hashCode():int", "toString():java.lang.String");
    private final String fullName;
    private final String shortName;
    private final String name;
    private final String returnType;
    private final String parameters;
    private final Visibility visibility;
    private final Set<String> writtenFields;
    private final Set<String> readFields;
    private final Set<String> invokedLocalMethods;

    public MethodDescriptor(String fullName, String shortName, Visibility visibility, String name, String returnType, String parameters) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.visibility = visibility;
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
        this.writtenFields = new HashSet<String>();
        this.readFields = new HashSet<String>();
        this.invokedLocalMethods = new HashSet<String>();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public boolean isConstructor() {
        return this.name.contains("<init>") || this.name.contains("<clinit>");
    }

    public String getParameters() {
        return this.parameters;
    }

    public void addFieldWrite(String name) {
        this.writtenFields.add(name);
    }

    public void addFieldRead(String name) {
        this.readFields.add(name);
    }

    public void addLocalMethodInvocation(String methodName) {
        this.invokedLocalMethods.add(methodName);
    }

    public Set<String> getWrittenFields() {
        return this.writtenFields;
    }

    public Set<String> getReadFields() {
        return this.readFields;
    }

    public Set<String> getInvokedLocalMethods() {
        return this.invokedLocalMethods;
    }

    public boolean matches(String shortName) {
        return this.shortName.equals(shortName);
    }

    public boolean callsOtherLocalMethods() {
        return !this.invokedLocalMethods.isEmpty();
    }

    public boolean readOrModifyOneSingleField() {
        Set<String> fields = Relation.combine(this.getReadFields(), this.getWrittenFields());
        return fields.size() == 1;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isSpecialMethod() {
        return this.isConstructor() || SPECIAL_METHODS.contains(this.shortName);
    }
}

