/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.analyzer;

import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.Visibility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class CohesionAnalyzer {
    public Set<MethodDescriptor> analyze(ClassReader classReader) {
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
        for (MethodNode methodNode : classNode.methods) {
            String shortName = CohesionAnalyzer.generateShortMethodName(methodNode);
            MethodDescriptor method = methods.computeIfAbsent(shortName, ignored -> new MethodDescriptor(this.generateFullMethodSignature(methodNode), CohesionAnalyzer.generateShortMethodName(methodNode), Visibility.parse(methodNode.access), methodNode.name, CohesionAnalyzer.getReturnType(methodNode), CohesionAnalyzer.getParameterTypes(methodNode.desc)));
            CohesionMethodAnalyzer visitor = new CohesionMethodAnalyzer(classNode.name, method);
            methodNode.accept((MethodVisitor)visitor);
        }
        return Set.copyOf(methods.values());
    }

    private String generateFullMethodSignature(MethodNode method) {
        String returnType = CohesionAnalyzer.getReturnType(method);
        String parameterTypes = CohesionAnalyzer.getParameterTypes(method.desc);
        String methodVisibility = Visibility.parse(method.access).name().toLowerCase();
        return String.format("%s %s %s(%s)", methodVisibility, returnType, method.name, parameterTypes);
    }

    private static String getReturnType(MethodNode method) {
        return Type.getReturnType((String)method.desc).getClassName();
    }

    private static String generateShortMethodName(MethodNode method) {
        return CohesionAnalyzer.generateShortMethodName(method.name, method.desc);
    }

    private static String generateShortMethodName(String name, String descriptor) {
        String returnType = Type.getReturnType((String)descriptor).getClassName();
        String parameterTypes = CohesionAnalyzer.getParameterTypes(descriptor);
        return String.format("%s(%s):%s", name, parameterTypes, returnType);
    }

    private static String getParameterTypes(String descriptor) {
        return String.join((CharSequence)"; ", Arrays.stream(Type.getMethodType((String)descriptor).getArgumentTypes()).map(Type::getClassName).toList());
    }

    private static class CohesionMethodAnalyzer
    extends MethodVisitor {
        private final String owner;
        private final MethodDescriptor method;

        CohesionMethodAnalyzer(String owner, MethodDescriptor method) {
            super(589824);
            this.owner = owner;
            this.method = method;
        }

        public void visitFieldInsn(int opcode, String owner, String fieldName, String fieldType) {
            switch (FieldOperation.parse(opcode)) {
                case READ: {
                    this.method.addFieldRead(fieldName);
                    break;
                }
                case WRITE: {
                    this.method.addFieldWrite(fieldName);
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.owner.equals(owner)) {
                this.method.addLocalMethodInvocation(CohesionAnalyzer.generateShortMethodName(name, descriptor));
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.method.incLineCounter();
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    public static enum FieldOperation {
        READ,
        WRITE,
        IRRELEVANT;


        public static FieldOperation parse(int asmOpCode) {
            return switch (asmOpCode) {
                case 181 -> WRITE;
                case 180 -> READ;
                default -> IRRELEVANT;
            };
        }
    }
}

