/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.LCOM4Calculator;
import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.Visibility;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public record ClassDescriptor(String className, boolean isAbstract, Visibility visibility, Set<String> dependencies, Set<MethodDescriptor> methods) {
    public boolean hasDependency(Set<String> check) {
        return this.dependencies.stream().anyMatch(check::contains);
    }

    public void addMethods(Set<MethodDescriptor> methods) {
        this.methods.addAll(methods);
    }

    public int countPublicMethodsInClass() {
        return (int)this.methods.stream().filter(Predicate.not(MethodDescriptor::isConstructor)).filter(MethodDescriptor::isPublic).count();
    }

    public int countMethodsInClass() {
        return (int)this.methods.stream().filter(Predicate.not(MethodDescriptor::isConstructor)).count();
    }

    public int countMethodsWithLocalCalls() {
        return (int)this.methods.stream().filter(Predicate.not(MethodDescriptor::isConstructor)).filter(MethodDescriptor::callsOtherLocalMethods).count();
    }

    public double averageLinesPerMethod() {
        Integer lines = this.methods.stream().filter(Predicate.not(MethodDescriptor::isConstructor)).map(MethodDescriptor::lines).reduce(Integer::sum).orElse(0);
        return this.methods.isEmpty() ? 0.0 : (double)lines.intValue() / (double)this.methods.size();
    }

    public int countMethodsWithOnlyOneInvolvedField() {
        return (int)this.methods.stream().filter(MethodDescriptor::readOrModifyOneSingleField).count();
    }

    public Set<MethodDescriptor> getFilteredMethods() {
        return this.methods.stream().filter(Predicate.not(MethodDescriptor::isSpecialMethod)).collect(Collectors.toSet());
    }

    public int lcom4() {
        LCOM4Calculator calculator = new LCOM4Calculator();
        return calculator.calculate(this.getFilteredMethods());
    }
}

