/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.ModuleDescriptor;
import java.util.function.Predicate;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class LineCountCalculator {
    public LineCountResult computeModule(ModuleDescriptor descriptor) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        descriptor.classes().stream().flatMap(x -> x.methods().stream()).filter(Predicate.not(MethodDescriptor::isSpecialMethod)).map(MethodDescriptor::lines).forEach(arg_0 -> ((DescriptiveStatistics)stats).addValue(arg_0));
        return new LineCountResult(stats);
    }

    public static class LineCountResult {
        private final DescriptiveStatistics stats;

        private LineCountResult(DescriptiveStatistics stats) {
            this.stats = stats;
        }

        public double percentile(double p) {
            return this.stats.getPercentile(p);
        }

        public double mean() {
            return this.stats.getMean();
        }

        public double median() {
            return this.stats.getPercentile(50.0);
        }

        public DescriptiveStatistics stats() {
            return this.stats;
        }
    }
}

