/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.Relation;
import ch.javacamp.metrics.core.Visibility;
import java.util.HashSet;
import java.util.Set;

public class MethodDescriptor {
    private static final Set<String> SPECIAL_METHODS = Set.of("equals(java.lang.Object):boolean", "hashCode():int", "toString():java.lang.String");
    private final String fullName;
    private final String shortName;
    private final String name;
    private final String returnType;
    private final String parameters;
    private final Visibility visibility;
    private final Set<String> writtenFields;
    private final Set<String> readFields;
    private final Set<String> invokedLocalMethods;
    private int lines;

    public MethodDescriptor(String fullName, String shortName, Visibility visibility, String name, String returnType, String parameters) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.visibility = visibility;
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
        this.writtenFields = new HashSet<String>();
        this.readFields = new HashSet<String>();
        this.invokedLocalMethods = new HashSet<String>();
        this.lines = 0;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public boolean isConstructor() {
        return this.name.contains("<init>") || this.name.contains("<clinit>");
    }

    public void addFieldWrite(String name) {
        this.writtenFields.add(name);
    }

    public void addFieldRead(String name) {
        this.readFields.add(name);
    }

    public void addLocalMethodInvocation(String methodName) {
        this.invokedLocalMethods.add(methodName);
    }

    public boolean matches(String shortName) {
        return this.shortName.equals(shortName);
    }

    public boolean callsOtherLocalMethods() {
        return !this.invokedLocalMethods.isEmpty();
    }

    public boolean readOrModifyOneSingleField() {
        Set<String> fields = Relation.combine(this.readFields(), this.writtenFields());
        return fields.size() == 1;
    }

    public boolean isSpecialMethod() {
        return this.isConstructor() || SPECIAL_METHODS.contains(this.shortName);
    }

    public void incLineCounter() {
        ++this.lines;
    }

    public MethodDescriptor(String fullName, String shortName, String name, String returnType, String parameters, Visibility visibility, Set<String> writtenFields, Set<String> readFields, Set<String> invokedLocalMethods, int lines) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
        this.visibility = visibility;
        this.writtenFields = writtenFields;
        this.readFields = readFields;
        this.invokedLocalMethods = invokedLocalMethods;
        this.lines = lines;
    }

    public String fullName() {
        return this.fullName;
    }

    public String shortName() {
        return this.shortName;
    }

    public String name() {
        return this.name;
    }

    public String returnType() {
        return this.returnType;
    }

    public String parameters() {
        return this.parameters;
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public Set<String> writtenFields() {
        return this.writtenFields;
    }

    public Set<String> readFields() {
        return this.readFields;
    }

    public Set<String> invokedLocalMethods() {
        return this.invokedLocalMethods;
    }

    public int lines() {
        return this.lines;
    }
}

