/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

public class MetricsResult {
    private final String name;
    private final long numberOfClasses;
    private final long ca;
    private final long ce;
    private final double abstractness;
    private final double instability;
    private final double distance;
    private final double averageMethodsPerClass;
    private final double averagePublicMethodsPerClass;
    private final double lcom4;
    private final double shareGetterSetters;
    private final double shareLocalCallMethods;
    private final MethodStatistics methodStatistics;

    public static MetricsResultBuilder builder() {
        return new MetricsResultBuilder();
    }

    public String name() {
        return this.name;
    }

    public long numberOfClasses() {
        return this.numberOfClasses;
    }

    public long ca() {
        return this.ca;
    }

    public long ce() {
        return this.ce;
    }

    public double abstractness() {
        return this.abstractness;
    }

    public double instability() {
        return this.instability;
    }

    public double distance() {
        return this.distance;
    }

    public double averageMethodsPerClass() {
        return this.averageMethodsPerClass;
    }

    public double averagePublicMethodsPerClass() {
        return this.averagePublicMethodsPerClass;
    }

    public double lcom4() {
        return this.lcom4;
    }

    public double shareGetterSetters() {
        return this.shareGetterSetters;
    }

    public double shareLocalCallMethods() {
        return this.shareLocalCallMethods;
    }

    public MethodStatistics methodStatistics() {
        return this.methodStatistics;
    }

    private MetricsResult(String name, long numberOfClasses, long ca, long ce, double abstractness, double instability, double distance, double averageMethodsPerClass, double averagePublicMethodsPerClass, double lcom4, double shareGetterSetters, double shareLocalCallMethods, MethodStatistics methodStatistics) {
        this.name = name;
        this.numberOfClasses = numberOfClasses;
        this.ca = ca;
        this.ce = ce;
        this.abstractness = abstractness;
        this.instability = instability;
        this.distance = distance;
        this.averageMethodsPerClass = averageMethodsPerClass;
        this.averagePublicMethodsPerClass = averagePublicMethodsPerClass;
        this.lcom4 = lcom4;
        this.shareGetterSetters = shareGetterSetters;
        this.shareLocalCallMethods = shareLocalCallMethods;
        this.methodStatistics = methodStatistics;
    }

    public static class MetricsResultBuilder {
        private String name;
        private long numberOfClasses;
        private long ca;
        private long ce;
        private double abstractness;
        private double instability;
        private double distance;
        private double averageMethodsPerClass;
        private double averagePublicMethodsPerClass;
        private double lcom4;
        private double shareGetterSetters;
        private double shareLocalCallMethods;
        private MethodStatistics methodStatistics;

        MetricsResultBuilder() {
        }

        public MetricsResultBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricsResultBuilder numberOfClasses(long numberOfClasses) {
            this.numberOfClasses = numberOfClasses;
            return this;
        }

        public MetricsResultBuilder ca(long ca) {
            this.ca = ca;
            return this;
        }

        public MetricsResultBuilder ce(long ce) {
            this.ce = ce;
            return this;
        }

        public MetricsResultBuilder abstractness(double abstractness) {
            this.abstractness = abstractness;
            return this;
        }

        public MetricsResultBuilder instability(double instability) {
            this.instability = instability;
            return this;
        }

        public MetricsResultBuilder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public MetricsResultBuilder averageMethodsPerClass(double averageMethodsPerClass) {
            this.averageMethodsPerClass = averageMethodsPerClass;
            return this;
        }

        public MetricsResultBuilder averagePublicMethodsPerClass(double averagePublicMethodsPerClass) {
            this.averagePublicMethodsPerClass = averagePublicMethodsPerClass;
            return this;
        }

        public MetricsResultBuilder lcom4(double lcom4) {
            this.lcom4 = lcom4;
            return this;
        }

        public MetricsResultBuilder shareGetterSetters(double shareGetterSetters) {
            this.shareGetterSetters = shareGetterSetters;
            return this;
        }

        public MetricsResultBuilder shareLocalCallMethods(double shareLocalCallMethods) {
            this.shareLocalCallMethods = shareLocalCallMethods;
            return this;
        }

        public MetricsResultBuilder methodStatistics(MethodStatistics methodStatistics) {
            this.methodStatistics = methodStatistics;
            return this;
        }

        public MetricsResult build() {
            return new MetricsResult(this.name, this.numberOfClasses, this.ca, this.ce, this.abstractness, this.instability, this.distance, this.averageMethodsPerClass, this.averagePublicMethodsPerClass, this.lcom4, this.shareGetterSetters, this.shareLocalCallMethods, this.methodStatistics);
        }

        public String toString() {
            return "MetricsResult.MetricsResultBuilder(name=" + this.name + ", numberOfClasses=" + this.numberOfClasses + ", ca=" + this.ca + ", ce=" + this.ce + ", abstractness=" + this.abstractness + ", instability=" + this.instability + ", distance=" + this.distance + ", averageMethodsPerClass=" + this.averageMethodsPerClass + ", averagePublicMethodsPerClass=" + this.averagePublicMethodsPerClass + ", lcom4=" + this.lcom4 + ", shareGetterSetters=" + this.shareGetterSetters + ", shareLocalCallMethods=" + this.shareLocalCallMethods + ", methodStatistics=" + this.methodStatistics + ")";
        }
    }

    public static class MethodStatistics {
        double mean;
        double median;
        double percentile25;
        double percentile75;
        double percentile80;
        double percentile90;
        double percentile95;
        double percentile99;

        public static MethodStatisticsBuilder builder() {
            return new MethodStatisticsBuilder();
        }

        public double mean() {
            return this.mean;
        }

        public double median() {
            return this.median;
        }

        public double percentile25() {
            return this.percentile25;
        }

        public double percentile75() {
            return this.percentile75;
        }

        public double percentile80() {
            return this.percentile80;
        }

        public double percentile90() {
            return this.percentile90;
        }

        public double percentile95() {
            return this.percentile95;
        }

        public double percentile99() {
            return this.percentile99;
        }

        private MethodStatistics(double mean, double median, double percentile25, double percentile75, double percentile80, double percentile90, double percentile95, double percentile99) {
            this.mean = mean;
            this.median = median;
            this.percentile25 = percentile25;
            this.percentile75 = percentile75;
            this.percentile80 = percentile80;
            this.percentile90 = percentile90;
            this.percentile95 = percentile95;
            this.percentile99 = percentile99;
        }

        public static class MethodStatisticsBuilder {
            private double mean;
            private double median;
            private double percentile25;
            private double percentile75;
            private double percentile80;
            private double percentile90;
            private double percentile95;
            private double percentile99;

            MethodStatisticsBuilder() {
            }

            public MethodStatisticsBuilder mean(double mean) {
                this.mean = mean;
                return this;
            }

            public MethodStatisticsBuilder median(double median) {
                this.median = median;
                return this;
            }

            public MethodStatisticsBuilder percentile25(double percentile25) {
                this.percentile25 = percentile25;
                return this;
            }

            public MethodStatisticsBuilder percentile75(double percentile75) {
                this.percentile75 = percentile75;
                return this;
            }

            public MethodStatisticsBuilder percentile80(double percentile80) {
                this.percentile80 = percentile80;
                return this;
            }

            public MethodStatisticsBuilder percentile90(double percentile90) {
                this.percentile90 = percentile90;
                return this;
            }

            public MethodStatisticsBuilder percentile95(double percentile95) {
                this.percentile95 = percentile95;
                return this;
            }

            public MethodStatisticsBuilder percentile99(double percentile99) {
                this.percentile99 = percentile99;
                return this;
            }

            public MethodStatistics build() {
                return new MethodStatistics(this.mean, this.median, this.percentile25, this.percentile75, this.percentile80, this.percentile90, this.percentile95, this.percentile99);
            }

            public String toString() {
                return "MetricsResult.MethodStatistics.MethodStatisticsBuilder(mean=" + this.mean + ", median=" + this.median + ", percentile25=" + this.percentile25 + ", percentile75=" + this.percentile75 + ", percentile80=" + this.percentile80 + ", percentile90=" + this.percentile90 + ", percentile95=" + this.percentile95 + ", percentile99=" + this.percentile99 + ")";
            }
        }
    }
}

