/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.ClassDescriptor;
import ch.javacamp.metrics.core.LineCountCalculator;
import ch.javacamp.metrics.core.MetricsResult;
import ch.javacamp.metrics.core.ModuleDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class Modules {
    private final List<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();

    public void addModule(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor.totalClasses() > 0L) {
            this.modules.add(moduleDescriptor);
        }
    }

    public Set<ModuleDescriptor> otherModules(ModuleDescriptor toExclude) {
        return this.modules.stream().filter(x -> x != toExclude).collect(Collectors.toSet());
    }

    public Set<ClassDescriptor> externalClassesUsingClassesInThisModule(ModuleDescriptor module) {
        Set<String> classNamesCurrentModule = module.allClassNames();
        Set<ModuleDescriptor> otherModules = this.otherModules(module);
        return otherModules.stream().flatMap(x -> x.classes().stream()).filter(c -> c.hasDependency(classNamesCurrentModule)).collect(Collectors.toSet());
    }

    public Set<ClassDescriptor> externalClassesUsedByThisModule(ModuleDescriptor module) {
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        Set allClassNamesOutsideCurrentModule = this.otherModules(module).stream().flatMap(x -> x.classes().stream()).map(ClassDescriptor::className).collect(Collectors.toSet());
        for (ClassDescriptor classDescriptor : module.classes()) {
            for (String dependency : classDescriptor.dependencies()) {
                if (!allClassNamesOutsideCurrentModule.contains(dependency)) continue;
                result.add(classDescriptor);
            }
        }
        return result;
    }

    public MetricsResult computeMetrics(ModuleDescriptor module) {
        Set<ClassDescriptor> outsideClassesWithDependenciesToMe = this.externalClassesUsingClassesInThisModule(module);
        Set<ClassDescriptor> classesWithForeignDependencies = this.externalClassesUsedByThisModule(module);
        int ca = outsideClassesWithDependenciesToMe.size();
        int ce = classesWithForeignDependencies.size();
        double i = (double)ce / (double)(ce + ca);
        double a = module.abstractness();
        double d = Math.abs((a + i - 1.0) / 2.0);
        double lcom4 = module.averageLCOM4();
        double shareOfGetterSetters = module.shareOfGetterSetters();
        double shareOfMethodsWithLocalCalls = module.shareOfMethodsWithLocalCalls();
        MetricsResult.MethodStatistics methodStatistics = Modules.computeMethodStatistics(module);
        return new MetricsResult.MetricsResultBuilder().numberOfClasses(module.totalClasses()).name(module.name()).ca(ca).ce(ce).instability(i).abstractness(a).distance(d).lcom4(lcom4).shareGetterSetters(shareOfGetterSetters).shareLocalCallMethods(shareOfMethodsWithLocalCalls).methodStatistics(methodStatistics).build();
    }

    private static MetricsResult.MethodStatistics computeMethodStatistics(ModuleDescriptor module) {
        LineCountCalculator.LineCountResult lineCountResult = new LineCountCalculator().computeModule(module);
        return MetricsResult.MethodStatistics.builder().median(lineCountResult.median()).mean(lineCountResult.mean()).percentile25(lineCountResult.percentile(25.0)).percentile75(lineCountResult.percentile(75.0)).percentile80(lineCountResult.percentile(80.0)).percentile90(lineCountResult.percentile(90.0)).percentile95(lineCountResult.percentile(95.0)).percentile99(lineCountResult.percentile(99.0)).build();
    }

    public List<MetricsResult> computeMetrics() {
        ArrayList<MetricsResult> result = new ArrayList<MetricsResult>();
        for (ModuleDescriptor currentModule : this.getModules()) {
            result.add(this.computeMetrics(currentModule));
        }
        return result;
    }

    public List<ModuleDescriptor> getModules() {
        return this.modules;
    }
}

