/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.MethodDescriptor;
import ch.javacamp.metrics.core.MethodInvocation;
import ch.javacamp.metrics.core.ModuleDescriptor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CallFlowCalculator {
    Map<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();

    public void calculate(List<ModuleDescriptor> modules) {
        modules.stream().flatMap(x -> x.classes().stream()).flatMap(x -> x.methods().stream()).forEach(x -> this.methods.put(x.fqn(), (MethodDescriptor)x));
        Set metrics = this.methods.values().stream().map(method -> FlowMetric.builder().method((MethodDescriptor)method).maxCallDepth(this.maxDepth((MethodDescriptor)method)).numberOfClassesInFlow(this.numClasses((MethodDescriptor)method)).pathLength(this.pathLength((MethodDescriptor)method)).build()).collect(Collectors.toSet());
        System.out.println();
        System.out.println("--- Depth ---");
        metrics.stream().sorted(Comparator.comparingInt(FlowMetric::maxCallDepth).reversed()).limit(10L).map(m -> String.format("%s: %d", m.fqn(), m.maxCallDepth)).forEach(System.out::println);
        System.out.println();
        System.out.println("--- Classes ---");
        metrics.stream().sorted(Comparator.comparingInt(FlowMetric::numberOfClassesInFlow).reversed()).limit(10L).map(m -> String.format("%s: %d", m.fqn(), m.numberOfClassesInFlow)).forEach(System.out::println);
        System.out.println();
        System.out.println("--- Path Length ---");
        metrics.stream().sorted(Comparator.comparingInt(FlowMetric::pathLength).reversed()).limit(10L).map(m -> String.format("%s: %d", m.fqn(), m.pathLength)).forEach(System.out::println);
    }

    private int maxDepth(MethodDescriptor m) {
        return this.maxDepth(m, 0, new HashSet<String>());
    }

    private int maxDepth(MethodDescriptor m, int d, Set<String> cycleCheck) {
        if (m == null || !cycleCheck.add(m.fqn())) {
            return d;
        }
        return m.invokedMethods().stream().map(MethodInvocation::fqn).map(fqn -> this.maxDepth(this.methods.get(fqn), d + 1, cycleCheck)).max(Comparator.naturalOrder()).orElse(d);
    }

    private int pathLength(MethodDescriptor m) {
        return this.pathLength(m, 0, new HashSet<String>());
    }

    private int pathLength(MethodDescriptor m, int d, Set<String> cycleCheck) {
        if (m == null || !cycleCheck.add(m.fqn())) {
            return d;
        }
        return m.invokedMethods().stream().map(MethodInvocation::fqn).map(fqn -> this.pathLength(this.methods.get(fqn), d + 1, cycleCheck)).reduce(Integer::sum).orElse(0);
    }

    private int numClasses(MethodDescriptor m) {
        return this.numClasses(m, 0, new HashSet<String>(), new HashSet<String>()).size();
    }

    private Set<String> numClasses(MethodDescriptor m, int d, Set<String> cycleCheck, Set<String> classes) {
        if (m == null || !cycleCheck.add(m.fqn())) {
            return classes;
        }
        classes.add(m.owner());
        return m.invokedMethods().stream().map(MethodInvocation::fqn).flatMap(fqn -> this.numClasses(this.methods.get(fqn), d + 1, cycleCheck, classes).stream()).collect(Collectors.toSet());
    }

    public static class FlowMetric {
        MethodDescriptor method;
        int numberOfClassesInFlow;
        int maxCallDepth;
        int pathLength;

        public String fqn() {
            return this.method.fqn();
        }

        FlowMetric(MethodDescriptor method, int numberOfClassesInFlow, int maxCallDepth, int pathLength) {
            this.method = method;
            this.numberOfClassesInFlow = numberOfClassesInFlow;
            this.maxCallDepth = maxCallDepth;
            this.pathLength = pathLength;
        }

        public static FlowMetricBuilder builder() {
            return new FlowMetricBuilder();
        }

        public MethodDescriptor method() {
            return this.method;
        }

        public int numberOfClassesInFlow() {
            return this.numberOfClassesInFlow;
        }

        public int maxCallDepth() {
            return this.maxCallDepth;
        }

        public int pathLength() {
            return this.pathLength;
        }

        public static class FlowMetricBuilder {
            private MethodDescriptor method;
            private int numberOfClassesInFlow;
            private int maxCallDepth;
            private int pathLength;

            FlowMetricBuilder() {
            }

            public FlowMetricBuilder method(MethodDescriptor method) {
                this.method = method;
                return this;
            }

            public FlowMetricBuilder numberOfClassesInFlow(int numberOfClassesInFlow) {
                this.numberOfClassesInFlow = numberOfClassesInFlow;
                return this;
            }

            public FlowMetricBuilder maxCallDepth(int maxCallDepth) {
                this.maxCallDepth = maxCallDepth;
                return this;
            }

            public FlowMetricBuilder pathLength(int pathLength) {
                this.pathLength = pathLength;
                return this;
            }

            public FlowMetric build() {
                return new FlowMetric(this.method, this.numberOfClassesInFlow, this.maxCallDepth, this.pathLength);
            }

            public String toString() {
                return "CallFlowCalculator.FlowMetric.FlowMetricBuilder(method=" + this.method + ", numberOfClassesInFlow=" + this.numberOfClassesInFlow + ", maxCallDepth=" + this.maxCallDepth + ", pathLength=" + this.pathLength + ")";
            }
        }
    }
}

