/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.core;

import ch.javacamp.metrics.core.ClassDescriptor;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public record ModuleDescriptor(String name, Set<ClassDescriptor> classes) {
    public long abstractClasses() {
        return this.classes.stream().filter(ClassDescriptor::isAbstract).count();
    }

    public long totalClasses() {
        return this.classes.size();
    }

    public Set<String> allClassNames() {
        return this.classes.stream().map(ClassDescriptor::className).collect(Collectors.toSet());
    }

    public double abstractness() {
        return (double)this.abstractClasses() / (double)this.totalClasses();
    }

    public double averageLCOM4() {
        Integer sumLCOM4 = this.classes.stream().map(ClassDescriptor::lcom4).reduce(Integer::sum).orElse(0);
        return (double)sumLCOM4.intValue() / (double)this.classes.size();
    }

    public double shareOfGetterSetters() {
        Integer sumGetterSetters = this.classes.stream().map(ClassDescriptor::countMethodsWithOnlyOneInvolvedField).reduce(Integer::sum).orElse(0);
        Integer allMethods = this.classes.stream().map(ClassDescriptor::countMethodsInClass).reduce(Integer::sum).orElse(0);
        return (double)sumGetterSetters.intValue() / (double)allMethods.intValue();
    }

    public double shareOfMethodsWithLocalCalls() {
        Integer sumGetterSetters = this.classes.stream().map(ClassDescriptor::countMethodsWithLocalCalls).reduce(Integer::sum).orElse(0);
        Integer allMethods = this.classes.stream().map(ClassDescriptor::countMethodsInClass).reduce(Integer::sum).orElse(0);
        return (double)sumGetterSetters.intValue() / (double)allMethods.intValue();
    }

    public double averageMethodsPerClass() {
        Integer methods = this.classes.stream().map(ClassDescriptor::countMethodsInClass).reduce(Integer::sum).orElse(0);
        return (double)methods.intValue() / (double)this.totalClasses();
    }

    public double averagePublicMethodsPerClass() {
        Integer methods = this.classes.stream().map(ClassDescriptor::countPublicMethodsInClass).reduce(Integer::sum).orElse(0);
        return (double)methods.intValue() / (double)this.totalClasses();
    }

    public double averageLinesPerMethod() {
        return this.classes.stream().filter(Predicate.not(ClassDescriptor::isAbstract)).map(ClassDescriptor::averageLinesPerMethod).reduce(Double::sum).orElse(0.0) / (double)this.classes.size();
    }
}

