/*
 * Decompiled with CFR 0.152.
 */
package ch.javacamp.metrics.rendering;

import ch.javacamp.metrics.core.MetricsResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class Renderer {
    public static final String HTML_TEMPLATE = "template/report-js.html";
    private final Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().create();

    public void render(Path outputFile, List<MetricsResult> results) {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(HTML_TEMPLATE);){
            Objects.requireNonNull(is);
            String template = IOUtils.toString((InputStream)is);
            template = template.replace("##data##", this.gson.toJson(results));
            Files.writeString(outputFile, (CharSequence)template, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

