/*
 * Decompiled with CFR 0.152.
 */
package akka.serial.sync;

import akka.serial.PortClosedException;
import akka.serial.SerialSettings;
import akka.serial.sync.SerialConnection$;
import akka.serial.sync.UnsafeSerial;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001%\u0011\u0001cU3sS\u0006d7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001B:z]\u000eT!!\u0002\u0004\u0002\rM,'/[1m\u0015\u00059\u0011\u0001B1lW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\u0007k:\u001c\u0018MZ3\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001D+og\u00064WmU3sS\u0006d\u0007\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\tA|'\u000f^\u000b\u00023A\u0011!$\t\b\u00037}\u0001\"\u0001\b\u0007\u000e\u0003uQ!A\b\u0005\u0002\rq\u0012xn\u001c;?\u0013\t\u0001C\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\r\u0011!)\u0003A!A!\u0002\u0013I\u0012!\u00029peR\u0004\u0003\"B\u0014\u0001\t\u0013A\u0013A\u0002\u001fj]&$h\bF\u0002*U-\u0002\"a\u0005\u0001\t\u000bE1\u0003\u0019\u0001\n\t\u000b]1\u0003\u0019A\r\t\u000f5\u0002\u0001\u0019!C\u0005]\u00059!/Z1eS:<W#A\u0018\u0011\u0005-\u0001\u0014BA\u0019\r\u0005\u001d\u0011un\u001c7fC:Dqa\r\u0001A\u0002\u0013%A'A\u0006sK\u0006$\u0017N\\4`I\u0015\fHCA\u001b9!\tYa'\u0003\u00028\u0019\t!QK\\5u\u0011\u001dI$'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019Y\u0004\u0001)Q\u0005_\u0005A!/Z1eS:<\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\u0002 \u0002\u0011I,\u0017\r\u001a'pG.,\u0012a\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bA\u0001\\1oO*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005\u0019y%M[3di\"1\u0001\n\u0001Q\u0001\n}\n\u0011B]3bI2{7m\u001b\u0011\t\u000f)\u0003\u0001\u0019!C\u0005]\u00059qO]5uS:<\u0007b\u0002'\u0001\u0001\u0004%I!T\u0001\foJLG/\u001b8h?\u0012*\u0017\u000f\u0006\u00026\u001d\"9\u0011hSA\u0001\u0002\u0004y\u0003B\u0002)\u0001A\u0003&q&\u0001\u0005xe&$\u0018N\\4!\u0011\u001d\u0011\u0006A1A\u0005\ny\n\u0011b\u001e:ji\u0016dunY6\t\rQ\u0003\u0001\u0015!\u0003@\u0003)9(/\u001b;f\u0019>\u001c7\u000e\t\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0003\u0019\u0019Gn\\:fIV\t\u0001\f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u00061\u0011\r^8nS\u000eT!!\u00180\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002`\u0007\u0006!Q\u000f^5m\u0013\t\t'LA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007G\u0002\u0001\u000b\u0011\u0002-\u0002\u000f\rdwn]3eA!)Q\r\u0001C\u0001]\u0005A\u0011n]\"m_N,G\rC\u0003h\u0001\u0011\u0005\u0001.A\u0003dY>\u001cX\rF\u00016\u0011\u0015Q\u0007\u0001\"\u0001l\u0003\u0011\u0011X-\u00193\u0015\u00051|\u0007CA\u0006n\u0013\tqGBA\u0002J]RDQ\u0001]5A\u0002E\faAY;gM\u0016\u0014\bC\u0001:v\u001b\u0005\u0019(B\u0001;D\u0003\rq\u0017n\\\u0005\u0003mN\u0014!BQ=uK\n+hMZ3s\u0011\u0015A\b\u0001\"\u0001z\u0003\u00159(/\u001b;f)\ta'\u0010C\u0003qo\u0002\u0007\u0011oB\u0003}\u0005!\u0005Q0\u0001\tTKJL\u0017\r\\\"p]:,7\r^5p]B\u00111C \u0004\u0006\u0003\tA\ta`\n\u0003}*Aaa\n@\u0005\u0002\u0005\rA#A?\t\u000f\u0005\u001da\u0010\"\u0001\u0002\n\u0005!q\u000e]3o)\u0015I\u00131BA\u0007\u0011\u00199\u0012Q\u0001a\u00013!A\u0011qBA\u0003\u0001\u0004\t\t\"\u0001\u0005tKR$\u0018N\\4t!\u0011\t\u0019\"!\u0006\u000e\u0003\u0011I1!a\u0006\u0005\u00059\u0019VM]5bYN+G\u000f^5oON\u0004")
public class SerialConnection {
    private final UnsafeSerial unsafe;
    private final String port;
    private boolean reading;
    private final Object readLock;
    private boolean writing;
    private final Object writeLock;
    private final AtomicBoolean closed;

    public static SerialConnection open(String string, SerialSettings serialSettings) {
        return SerialConnection$.MODULE$.open(string, serialSettings);
    }

    public String port() {
        return this.port;
    }

    private boolean reading() {
        return this.reading;
    }

    private void reading_$eq(boolean x$1) {
        this.reading = x$1;
    }

    private Object readLock() {
        return this.readLock;
    }

    private boolean writing() {
        return this.writing;
    }

    private void writing_$eq(boolean x$1) {
        this.writing = x$1;
    }

    private Object writeLock() {
        return this.writeLock;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public boolean isClosed() {
        return this.closed().get();
    }

    public synchronized void close() {
        block8: {
            if (this.closed().get()) break block8;
            this.closed().set(true);
            this.unsafe.cancelRead();
            Object object = this.readLock();
            synchronized (object) {
                while (this.reading()) {
                    this.wait();
                }
            }
            Object object2 = this.writeLock();
            synchronized (object2) {
                while (this.writing()) {
                    this.wait();
                }
            }
            this.unsafe.close();
        }
    }

    public int read(ByteBuffer buffer) {
        int n;
        Object object = this.readLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.reading_$eq(true);
                    int n3 = this.unsafe.read(buffer);
                    buffer.limit(n3);
                    n2 = n3;
                }
                finally {
                    this.reading_$eq(false);
                    if (this.closed().get()) {
                        this.readLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is closed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.port()})));
            }
            n = n2;
        }
        return n;
    }

    public int write(ByteBuffer buffer) {
        int n;
        Object object = this.writeLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.writing_$eq(true);
                    n2 = this.unsafe.write(buffer, buffer.position());
                }
                finally {
                    this.writing_$eq(false);
                    if (this.closed().get()) {
                        this.writeLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is closed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.port()})));
            }
            n = n2;
        }
        return n;
    }

    public SerialConnection(UnsafeSerial unsafe, String port) {
        this.unsafe = unsafe;
        this.port = port;
        this.reading = false;
        this.readLock = new Object();
        this.writing = false;
        this.writeLock = new Object();
        this.closed = new AtomicBoolean(false);
    }
}

