/*
 * Decompiled with CFR 0.152.
 */
package akka.serial.sync;

import akka.serial.PortClosedException;
import akka.serial.SerialSettings;
import akka.serial.sync.SerialConnection$;
import akka.serial.sync.UnsafeSerial;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\r\u001b\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011)\u0019!C\u0001]!A!\b\u0001B\u0001B\u0003%q\u0006C\u0003<\u0001\u0011%A\bC\u0004A\u0001\u0001\u0007I\u0011B!\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\"1A\n\u0001Q!\n\tCq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\b1\u0002\u0001\r\u0011\"\u0003B\u0011\u001dI\u0006\u00011A\u0005\niCa\u0001\u0018\u0001!B\u0013\u0011\u0005bB/\u0001\u0005\u0004%IA\u0014\u0005\u0007=\u0002\u0001\u000b\u0011B(\t\u000f}\u0003!\u0019!C\u0005A\"11\u000e\u0001Q\u0001\n\u0005DQ\u0001\u001c\u0001\u0005\u0002\u0005CQ!\u001c\u0001\u0005\u00029DQa\u001c\u0001\u0005\u0002ADQ\u0001 \u0001\u0005\u0002u<aa \u000e\t\u0002\u0005\u0005aAB\r\u001b\u0011\u0003\t\u0019\u0001\u0003\u0004<-\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u000f1B\u0011AA\u0005\u0005A\u0019VM]5bY\u000e{gN\\3di&|gN\u0003\u0002\u001c9\u0005!1/\u001f8d\u0015\tib$\u0001\u0004tKJL\u0017\r\u001c\u0006\u0002?\u0005!\u0011m[6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019)hn]1gKB\u0011!fK\u0007\u00025%\u0011AF\u0007\u0002\r+:\u001c\u0018MZ3TKJL\u0017\r\\\u0001\u0005a>\u0014H/F\u00010!\t\u0001tG\u0004\u00022kA\u0011!\u0007J\u0007\u0002g)\u0011A\u0007I\u0001\u0007yI|w\u000e\u001e \n\u0005Y\"\u0013A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0013\u0002\u000bA|'\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\ridh\u0010\t\u0003U\u0001AQ\u0001\u000b\u0003A\u0002%BQ!\f\u0003A\u0002=\nqA]3bI&tw-F\u0001C!\t\u00193)\u0003\u0002EI\t9!i\\8mK\u0006t\u0017a\u0003:fC\u0012LgnZ0%KF$\"a\u0012&\u0011\u0005\rB\u0015BA%%\u0005\u0011)f.\u001b;\t\u000f-3\u0011\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\u0002\u0011I,\u0017\rZ5oO\u0002\n\u0001B]3bI2{7m[\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005Y\u0006twMC\u0001U\u0003\u0011Q\u0017M^1\n\u0005Y\u000b&AB(cU\u0016\u001cG/A\u0005sK\u0006$Gj\\2lA\u00059qO]5uS:<\u0017aC<sSRLgnZ0%KF$\"aR.\t\u000f-[\u0011\u0011!a\u0001\u0005\u0006AqO]5uS:<\u0007%A\u0005xe&$X\rT8dW\u0006QqO]5uK2{7m\u001b\u0011\u0002\r\rdwn]3e+\u0005\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003\u0019\tGo\\7jG*\u0011amZ\u0001\u000bG>t7-\u001e:sK:$(B\u00015T\u0003\u0011)H/\u001b7\n\u0005)\u001c'!D!u_6L7MQ8pY\u0016\fg.A\u0004dY>\u001cX\r\u001a\u0011\u0002\u0011%\u001c8\t\\8tK\u0012\fQa\u00197pg\u0016$\u0012aR\u0001\u0005e\u0016\fG\r\u0006\u0002riB\u00111E]\u0005\u0003g\u0012\u00121!\u00138u\u0011\u0015)8\u00031\u0001w\u0003\u0019\u0011WO\u001a4feB\u0011qO_\u0007\u0002q*\u0011\u0011pU\u0001\u0004]&|\u0017BA>y\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u0006oJLG/\u001a\u000b\u0003czDQ!\u001e\u000bA\u0002Y\f\u0001cU3sS\u0006d7i\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005)22C\u0001\f#)\t\t\t!\u0001\u0003pa\u0016tG#B\u001f\u0002\f\u00055\u0001\"B\u0017\u0019\u0001\u0004y\u0003bBA\b1\u0001\u0007\u0011\u0011C\u0001\tg\u0016$H/\u001b8hgB!\u00111CA\u000b\u001b\u0005a\u0012bAA\f9\tq1+\u001a:jC2\u001cV\r\u001e;j]\u001e\u001c\b")
public class SerialConnection {
    private final UnsafeSerial unsafe;
    private final String port;
    private boolean reading;
    private final Object readLock;
    private boolean writing;
    private final Object writeLock;
    private final AtomicBoolean closed;

    public static SerialConnection open(String string, SerialSettings serialSettings) {
        return SerialConnection$.MODULE$.open(string, serialSettings);
    }

    public String port() {
        return this.port;
    }

    private boolean reading() {
        return this.reading;
    }

    private void reading_$eq(boolean x$1) {
        this.reading = x$1;
    }

    private Object readLock() {
        return this.readLock;
    }

    private boolean writing() {
        return this.writing;
    }

    private void writing_$eq(boolean x$1) {
        this.writing = x$1;
    }

    private Object writeLock() {
        return this.writeLock;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public boolean isClosed() {
        return this.closed().get();
    }

    public synchronized void close() {
        block8: {
            if (this.closed().get()) break block8;
            this.closed().set(true);
            this.unsafe.cancelRead();
            Object object = this.readLock();
            synchronized (object) {
                while (this.reading()) {
                    this.wait();
                }
            }
            Object object2 = this.writeLock();
            synchronized (object2) {
                while (this.writing()) {
                    this.wait();
                }
            }
            this.unsafe.close();
        }
    }

    public int read(ByteBuffer buffer) {
        int n;
        Object object = this.readLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.reading_$eq(true);
                    int n3 = this.unsafe.read(buffer);
                    buffer.limit(n3);
                    n2 = n3;
                }
                finally {
                    this.reading_$eq(false);
                    if (this.closed().get()) {
                        this.readLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringBuilder(10).append(this.port()).append(" is closed").toString());
            }
            n = n2;
        }
        return n;
    }

    public int write(ByteBuffer buffer) {
        int n;
        Object object = this.writeLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.writing_$eq(true);
                    n2 = this.unsafe.write(buffer, buffer.position());
                }
                finally {
                    this.writing_$eq(false);
                    if (this.closed().get()) {
                        this.writeLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringBuilder(10).append(this.port()).append(" is closed").toString());
            }
            n = n2;
        }
        return n;
    }

    public SerialConnection(UnsafeSerial unsafe, String port) {
        this.unsafe = unsafe;
        this.port = port;
        this.reading = false;
        this.readLock = new Object();
        this.writing = false;
        this.writeLock = new Object();
        this.closed = new AtomicBoolean(false);
    }
}

