/*
 * Decompiled with CFR 0.152.
 */
package ch.jodersky.flow;

import ch.jodersky.flow.PortClosedException;
import ch.jodersky.flow.SerialConnection$;
import ch.jodersky.flow.SerialSettings;
import ch.jodersky.flow.UnsafeSerial;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001\tA!\u0001E*fe&\fGnQ8o]\u0016\u001cG/[8o\u0015\t\u0019A!\u0001\u0003gY><(BA\u0003\u0007\u0003!Qw\u000eZ3sg.L(\"A\u0004\u0002\u0005\rD7C\u0001\u0001\n!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fM\"A\u0001\u0003\u0001B\u0001B\u0003%!#\u0001\u0004v]N\fg-Z\u0002\u0001!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u0007V]N\fg-Z*fe&\fG\u000e\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003\u0011\u0001xN\u001d;\u0016\u0003e\u0001\"AG\u0011\u000f\u0005my\u0002C\u0001\u000f\f\u001b\u0005i\"B\u0001\u0010\u0012\u0003\u0019a$o\\8u}%\u0011\u0001eC\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!\u0017!AQ\u0005\u0001B\u0001B\u0003%\u0011$A\u0003q_J$\b\u0005C\u0003(\u0001\u0011%\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0004S)Z\u0003CA\n\u0001\u0011\u0015\u0001b\u00051\u0001\u0013\u0011\u00159b\u00051\u0001\u001a\u0011\u001di\u0003\u00011A\u0005\n9\nqA]3bI&tw-F\u00010!\tQ\u0001'\u0003\u00022\u0017\t9!i\\8mK\u0006t\u0007bB\u001a\u0001\u0001\u0004%I\u0001N\u0001\fe\u0016\fG-\u001b8h?\u0012*\u0017\u000f\u0006\u00026qA\u0011!BN\u0005\u0003o-\u0011A!\u00168ji\"9\u0011HMA\u0001\u0002\u0004y\u0013a\u0001=%c!11\b\u0001Q!\n=\n\u0001B]3bI&tw\r\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003!\u0011X-\u00193M_\u000e\\W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n1qJ\u00196fGRDa\u0001\u0013\u0001!\u0002\u0013y\u0014!\u0003:fC\u0012dunY6!\u0011\u001dQ\u0005\u00011A\u0005\n9\nqa\u001e:ji&tw\rC\u0004M\u0001\u0001\u0007I\u0011B'\u0002\u0017]\u0014\u0018\u000e^5oO~#S-\u001d\u000b\u0003k9Cq!O&\u0002\u0002\u0003\u0007q\u0006\u0003\u0004Q\u0001\u0001\u0006KaL\u0001\toJLG/\u001b8hA!9!\u000b\u0001b\u0001\n\u0013q\u0014!C<sSR,Gj\\2l\u0011\u0019!\u0006\u0001)A\u0005\u007f\u0005QqO]5uK2{7m\u001b\u0011\t\u000fY\u0003!\u0019!C\u0005/\u000611\r\\8tK\u0012,\u0012\u0001\u0017\t\u00033\u0002l\u0011A\u0017\u0006\u00037r\u000ba!\u0019;p[&\u001c'BA/_\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003?\u000e\u000bA!\u001e;jY&\u0011\u0011M\u0017\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\r\r\u0004\u0001\u0015!\u0003Y\u0003\u001d\u0019Gn\\:fI\u0002BQ!\u001a\u0001\u0005\u00029\n\u0001\"[:DY>\u001cX\r\u001a\u0005\u0006O\u0002!\t\u0001[\u0001\u0006G2|7/\u001a\u000b\u0002k!)!\u000e\u0001C\u0001W\u0006!!/Z1e)\taw\u000e\u0005\u0002\u000b[&\u0011an\u0003\u0002\u0004\u0013:$\b\"\u00029j\u0001\u0004\t\u0018A\u00022vM\u001a,'\u000f\u0005\u0002sk6\t1O\u0003\u0002u\u0007\u0006\u0019a.[8\n\u0005Y\u001c(A\u0003\"zi\u0016\u0014UO\u001a4fe\")\u0001\u0010\u0001C\u0001s\u0006)qO]5uKR\u0011AN\u001f\u0005\u0006a^\u0004\r!]\u0004\u0007y\nA\tAA?\u0002!M+'/[1m\u0007>tg.Z2uS>t\u0007CA\n\u007f\r\u0019\t!\u0001#\u0001\u0003\u007fN\u0011a0\u0003\u0005\u0007Oy$\t!a\u0001\u0015\u0003uDq!a\u0002\u007f\t\u0003\tI!\u0001\u0003pa\u0016tG#B\u0015\u0002\f\u00055\u0001BB\f\u0002\u0006\u0001\u0007\u0011\u0004\u0003\u0005\u0002\u0010\u0005\u0015\u0001\u0019AA\t\u0003!\u0019X\r\u001e;j]\u001e\u001c\bcA\n\u0002\u0014%\u0019\u0011Q\u0003\u0002\u0003\u001dM+'/[1m'\u0016$H/\u001b8hg\u0002")
public class SerialConnection {
    private final UnsafeSerial unsafe;
    private final String port;
    private boolean reading;
    private final Object readLock;
    private boolean writing;
    private final Object writeLock;
    private final AtomicBoolean closed;

    public static SerialConnection open(String string, SerialSettings serialSettings) {
        return SerialConnection$.MODULE$.open(string, serialSettings);
    }

    public String port() {
        return this.port;
    }

    private boolean reading() {
        return this.reading;
    }

    private void reading_$eq(boolean x$1) {
        this.reading = x$1;
    }

    private Object readLock() {
        return this.readLock;
    }

    private boolean writing() {
        return this.writing;
    }

    private void writing_$eq(boolean x$1) {
        this.writing = x$1;
    }

    private Object writeLock() {
        return this.writeLock;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public boolean isClosed() {
        return this.closed().get();
    }

    public synchronized void close() {
        block8: {
            if (this.closed().get()) break block8;
            this.closed().set(true);
            this.unsafe.cancelRead();
            Object object = this.readLock();
            synchronized (object) {
                while (this.reading()) {
                    this.wait();
                }
            }
            Object object2 = this.writeLock();
            synchronized (object2) {
                while (this.writing()) {
                    this.wait();
                }
            }
            this.unsafe.close();
        }
    }

    public int read(ByteBuffer buffer) {
        int n;
        Object object = this.readLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.reading_$eq(true);
                    n2 = this.unsafe.read(buffer);
                }
                finally {
                    this.reading_$eq(false);
                    if (this.closed().get()) {
                        this.readLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is closed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.port()})));
            }
            n = n2;
        }
        return n;
    }

    public int write(ByteBuffer buffer) {
        int n;
        Object object = this.writeLock();
        synchronized (object) {
            int n2;
            if (!this.closed().get()) {
                try {
                    this.writing_$eq(true);
                    n2 = this.unsafe.write(buffer, buffer.position());
                }
                finally {
                    this.writing_$eq(false);
                    if (this.closed().get()) {
                        this.writeLock().notify();
                    }
                }
            } else {
                throw new PortClosedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is closed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.port()})));
            }
            n = n2;
        }
        return n;
    }

    public SerialConnection(UnsafeSerial unsafe, String port) {
        this.unsafe = unsafe;
        this.port = port;
        this.reading = false;
        this.readLock = new Object();
        this.writing = false;
        this.writeLock = new Object();
        this.closed = new AtomicBoolean(false);
    }
}

