/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBindingFactory;
import ch.kk7.confij.binding.ConfijDefinitionException;
import ch.kk7.confij.binding.intf.InterfaceBinding;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class InterfaceBindingFactory
implements ConfigBindingFactory<InterfaceBinding> {
    private final Deque<ResolvedType> callStack = new LinkedList<ResolvedType>();

    private String stackAsString() {
        return this.callStack.stream().map(ResolvedType::getBriefDescription).collect(Collectors.joining("\u2192"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<InterfaceBinding> maybeCreate(BindingType bindingType, ConfigBinder configBinder) {
        ResolvedType type = bindingType.getResolvedType();
        if (type.isInterface()) {
            if (this.callStack.contains(type) || type.getSelfReferencedType() != null) {
                throw new ConfijDefinitionException("circular interface definition {}: cannot add another {}", this.stackAsString(), type);
            }
            this.callStack.push(type);
            try {
                Optional<InterfaceBinding> optional = Optional.of(new InterfaceBinding(bindingType, configBinder));
                return optional;
            }
            finally {
                this.callStack.pop();
            }
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "InterfaceBindingFactory(callStack=" + this.callStack + ")";
    }
}

