/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.collection.CollectionBindingFactory;
import ch.kk7.confij.binding.collection.CollectionBuilder;
import ch.kk7.confij.binding.leaf.LeafBindingFactory;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class SeparatedMapper
implements ValueMapperFactory {
    private static Separated getContext(BindingType bindingType) {
        return bindingType.getBindingContext().getFactoryConfigFor(SeparatedMapper.class).filter(Separated.class::isInstance).map(Separated.class::cast).orElse(AnnonHolder.class.getAnnotation(Separated.class));
    }

    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        Collector collector;
        ResolvedType componentType;
        ResolvedType type = bindingType.getResolvedType();
        if (type.isArray()) {
            componentType = type.getArrayElementType();
            collector = Collectors.collectingAndThen(Collectors.toList(), list -> {
                Object array = Array.newInstance(componentType.getErasedType(), list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(array, i, list.get(i));
                }
                return array;
            });
        } else if (type.isInstanceOf(Collection.class)) {
            componentType = CollectionBindingFactory.collectionComponentType(type);
            collector = new CollectionBuilder(type).asCollector();
        } else {
            return Optional.empty();
        }
        Separated context = SeparatedMapper.getContext(bindingType);
        return LeafBindingFactory.firstValueMapper(bindingType.bindingFor(componentType)).map(componentMapper -> new SeparatedMapperInstance(componentMapper, collector, context));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=SeparatedMapper.class)
    public static @interface Separated {
        public String separator() default ",";

        public boolean trim() default false;
    }

    @Separated
    private static final class AnnonHolder {
        private AnnonHolder() {
        }
    }

    public static class SeparatedMapperInstance<T, C>
    implements ValueMapperInstance<T> {
        private final ValueMapperInstance<C> componentMapper;
        private final Collector<C, ?, T> collector;
        private final Separated context;

        @Override
        public T fromString(String string) {
            String[] parts = string == null ? new String[]{} : string.split(this.context.separator());
            return Stream.of(parts).map(s -> this.context.trim() ? s.trim() : s).map(this.componentMapper::fromString).collect(this.collector);
        }

        @Generated
        public SeparatedMapperInstance(ValueMapperInstance<C> componentMapper, Collector<C, ?, T> collector, Separated context) {
            this.componentMapper = componentMapper;
            this.collector = collector;
            this.context = context;
        }
    }
}

