/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import ch.kk7.confij.shadow.com.fasterxml.classmate.members.RawMethod;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public class StaticFunctionMapper
implements ValueMapperFactory {
    public static boolean isCallableMethod(Method method) {
        return Modifier.isStatic(method.getModifiers()) && method.getParameterCount() == 1 && String.class.equals(method.getParameterTypes()[0]) && method.getDeclaringClass().isAssignableFrom(method.getReturnType());
    }

    public static boolean isExpectedMethodName(String methodName, BindingType bindingType) {
        return Arrays.asList(bindingType.getBindingContext().getFactoryConfigFor(StaticFunctionMapper.class).filter(StaticFunction.class::isInstance).map(StaticFunction.class::cast).orElse(AnnonHolder.class.getAnnotation(StaticFunction.class)).value()).contains(methodName);
    }

    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        ResolvedType type = bindingType.getResolvedType();
        return type.getStaticMethods().stream().map(RawMethod::getRawMember).filter(StaticFunctionMapper::isCallableMethod).filter(method -> StaticFunctionMapper.isExpectedMethodName(method.getName(), bindingType)).findFirst().map(x$0 -> new StaticFunctionMapperInstance((Method)x$0));
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=StaticFunctionMapper.class)
    public static @interface StaticFunction {
        public String[] value() default {"valueOf", "fromString"};
    }

    @StaticFunction
    private static final class AnnonHolder {
        private AnnonHolder() {
        }
    }

    public class StaticFunctionMapperInstance<T>
    implements ValueMapperInstance.NullableValueMapperInstance<T> {
        private final Method method;

        protected StaticFunctionMapperInstance(Method method) {
            this.method = method;
        }

        @Override
        public T fromNonNullString(String string) {
            try {
                return (T)this.method.invoke(null, string);
            }
            catch (Exception e) {
                throw new ConfijBindingException("failed to instanitate a leaf object using its static method {}", this.method, e);
            }
        }
    }
}

