/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResource;
import ch.kk7.confij.template.ValueResolver;
import com.google.auto.service.AutoService;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class ClasspathResource
implements ConfijResource {
    @NonNull
    private final String nameTemplate;
    @NonNull
    private final String charsetTemplate;
    private final Class<?> classloaderOf;

    public ClasspathResource withCharset(Charset charset) {
        return this.withCharsetTemplate(charset.name());
    }

    public static ClasspathResource ofName(String nameTemplate) {
        return new ClasspathResource(nameTemplate, ConfijResource.Defaults.CHARSET_NAME, null);
    }

    @NonNull
    protected URL asUrl(String name) {
        URL url = this.classloaderOf == null ? ClassLoader.getSystemResource(name) : this.classloaderOf.getResource(name);
        if (url == null) {
            throw ConfijSourceFetchingException.unableToFetch(name, "no such file on classpath", new Object[0]);
        }
        return url;
    }

    @Override
    public Stream<ConfijResource.ResourceContent> read(ValueResolver.StringResolver resolver) {
        String name = resolver.resolve(this.nameTemplate);
        Charset charset = Charset.forName(resolver.resolve(this.charsetTemplate));
        URL classpathUrl = this.asUrl(name);
        return Stream.of(new ConfijResource.ResourceContent(URLResource.readUrl(classpathUrl, charset), name));
    }

    @Generated
    public ClasspathResource(@NonNull String nameTemplate, @NonNull String charsetTemplate, Class<?> classloaderOf) {
        if (nameTemplate == null) {
            throw new NullPointerException("nameTemplate is marked non-null but is null");
        }
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        this.nameTemplate = nameTemplate;
        this.charsetTemplate = charsetTemplate;
        this.classloaderOf = classloaderOf;
    }

    @NonNull
    @Generated
    public String getNameTemplate() {
        return this.nameTemplate;
    }

    @NonNull
    @Generated
    public String getCharsetTemplate() {
        return this.charsetTemplate;
    }

    @Generated
    public Class<?> getClassloaderOf() {
        return this.classloaderOf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClasspathResource)) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nameTemplate = this.getNameTemplate();
        String other$nameTemplate = other.getNameTemplate();
        if (this$nameTemplate == null ? other$nameTemplate != null : !this$nameTemplate.equals(other$nameTemplate)) {
            return false;
        }
        String this$charsetTemplate = this.getCharsetTemplate();
        String other$charsetTemplate = other.getCharsetTemplate();
        if (this$charsetTemplate == null ? other$charsetTemplate != null : !this$charsetTemplate.equals(other$charsetTemplate)) {
            return false;
        }
        Class<?> this$classloaderOf = this.getClassloaderOf();
        Class<?> other$classloaderOf = other.getClassloaderOf();
        return !(this$classloaderOf == null ? other$classloaderOf != null : !this$classloaderOf.equals(other$classloaderOf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClasspathResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nameTemplate = this.getNameTemplate();
        result = result * 59 + ($nameTemplate == null ? 43 : $nameTemplate.hashCode());
        String $charsetTemplate = this.getCharsetTemplate();
        result = result * 59 + ($charsetTemplate == null ? 43 : $charsetTemplate.hashCode());
        Class<?> $classloaderOf = this.getClassloaderOf();
        result = result * 59 + ($classloaderOf == null ? 43 : $classloaderOf.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClasspathResource(nameTemplate=" + this.getNameTemplate() + ", charsetTemplate=" + this.getCharsetTemplate() + ", classloaderOf=" + this.getClassloaderOf() + ")";
    }

    @Generated
    public ClasspathResource withCharsetTemplate(@NonNull String charsetTemplate) {
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        return this.charsetTemplate == charsetTemplate ? this : new ClasspathResource(this.nameTemplate, charsetTemplate, this.classloaderOf);
    }

    @Generated
    public ClasspathResource withClassloaderOf(Class<?> classloaderOf) {
        return this.classloaderOf == classloaderOf ? this : new ClasspathResource(this.nameTemplate, this.charsetTemplate, classloaderOf);
    }

    @AutoService(value={ConfijAnyResource.class})
    public static class AnyClasspathResource
    implements ConfijAnyResource {
        public static final String SCHEME = "classpath";

        public Optional<ClasspathResource> maybeHandle(String pathTemplate) {
            return Util.getScheme(pathTemplate).filter(scheme -> scheme.equals(SCHEME)).map(scheme -> {
                String path = Util.getSchemeSpecificPart(pathTemplate);
                return ClasspathResource.ofName(path);
            });
        }

        @Generated
        public String toString() {
            return "ClasspathResource.AnyClasspathResource()";
        }
    }
}

