/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PrimitiveMapperFactory
implements ValueMapperFactory {
    private final Map<Class<?>, ValueMapperInstance<?>> mappings = new HashMap();

    public PrimitiveMapperFactory() {
        this.withMapping(Boolean.TYPE, PrimitiveMapperFactory::parseBoolean);
        this.withMapping(Byte.TYPE, Byte::parseByte);
        this.withMapping(Short.TYPE, Short::parseShort);
        this.withMapping(Integer.TYPE, Integer::parseInt);
        this.withMapping(Long.TYPE, Long::parseLong);
        this.withMapping(Float.TYPE, Float::parseFloat);
        this.withMapping(Double.TYPE, Double::parseDouble);
        this.withMapping(Character.TYPE, PrimitiveMapperFactory::parseChar);
    }

    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        ResolvedType type = bindingType.getResolvedType();
        if (!type.isPrimitive()) {
            return Optional.empty();
        }
        return Optional.of(this.mappings.get(type.getErasedType()));
    }

    protected <T> void withMapping(Class<T> forClass, ValueMapperInstance.NullableValueMapperInstance<T> mapping) {
        this.mappings.put(forClass, mapping);
    }

    public static boolean parseBoolean(String string) {
        if ("false".equals(string)) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        throw BooleanFormatException.forInputString(string);
    }

    public static char parseChar(String string) {
        if (string.length() != 1) {
            throw CharFormatException.forInputString(string);
        }
        return string.charAt(0);
    }

    public static class BooleanFormatException
    extends IllegalArgumentException {
        public BooleanFormatException(String str) {
            super(str);
        }

        static BooleanFormatException forInputString(String str) {
            return new BooleanFormatException("cannot convert \"" + str + "\" to a boolean, valid are \"true\" and \"false\"");
        }
    }

    public static class CharFormatException
    extends IllegalArgumentException {
        public CharFormatException(String str) {
            super(str);
        }

        static CharFormatException forInputString(String str) {
            return new CharFormatException("cannot convert \"" + str + "\" to a char");
        }
    }
}

