/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.tree;

import ch.kk7.confij.annotation.Default;
import ch.kk7.confij.annotation.VariableResolver;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.common.ClassToImplCache;
import ch.kk7.confij.template.ValueResolver;
import java.lang.reflect.AnnotatedElement;
import lombok.Generated;
import lombok.NonNull;

public final class NodeBindingContext {
    private final AnnotatedElement annotatedElement;
    private final String defaultValue;
    @NonNull
    private final ValueResolver valueResolver;
    @NonNull
    private final ClassToImplCache implCache;

    public static NodeBindingContext newDefaultSettings(@NonNull ValueResolver valueResolver) {
        if (valueResolver == null) {
            throw new NullPointerException("valueResolver is marked non-null but is null");
        }
        ClassToImplCache implCache = new ClassToImplCache();
        implCache.put(valueResolver);
        return new NodeBindingContext(null, null, valueResolver, implCache);
    }

    protected NodeBindingContext withValueResolverFor(AnnotatedElement element) {
        return this.withValueResolver(AnnotationUtil.findAnnotation(element, VariableResolver.class).map(VariableResolver::value).map(x -> this.implCache.getInstance(x, ValueResolver.class)).orElse(this.valueResolver));
    }

    protected NodeBindingContext withDefaultValueFor(AnnotatedElement element) {
        return this.withDefaultValue(AnnotationUtil.findAnnotation(element, Default.class).map(x -> x.isNull() ? null : x.value()).orElse(this.defaultValue));
    }

    public NodeBindingContext settingsFor(AnnotatedElement element) {
        return this.withAnnotatedElement(element).withDefaultValueFor(element).withValueResolverFor(element);
    }

    @Generated
    public NodeBindingContext(AnnotatedElement annotatedElement, String defaultValue, @NonNull ValueResolver valueResolver, @NonNull ClassToImplCache implCache) {
        if (valueResolver == null) {
            throw new NullPointerException("valueResolver is marked non-null but is null");
        }
        if (implCache == null) {
            throw new NullPointerException("implCache is marked non-null but is null");
        }
        this.annotatedElement = annotatedElement;
        this.defaultValue = defaultValue;
        this.valueResolver = valueResolver;
        this.implCache = implCache;
    }

    @Generated
    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @NonNull
    @Generated
    public ValueResolver getValueResolver() {
        return this.valueResolver;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeBindingContext)) {
            return false;
        }
        NodeBindingContext other = (NodeBindingContext)o;
        AnnotatedElement this$annotatedElement = this.getAnnotatedElement();
        AnnotatedElement other$annotatedElement = other.getAnnotatedElement();
        if (this$annotatedElement == null ? other$annotatedElement != null : !this$annotatedElement.equals(other$annotatedElement)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        ValueResolver this$valueResolver = this.getValueResolver();
        ValueResolver other$valueResolver = other.getValueResolver();
        if (this$valueResolver == null ? other$valueResolver != null : !this$valueResolver.equals(other$valueResolver)) {
            return false;
        }
        ClassToImplCache this$implCache = this.implCache;
        ClassToImplCache other$implCache = other.implCache;
        return !(this$implCache == null ? other$implCache != null : !this$implCache.equals(other$implCache));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotatedElement $annotatedElement = this.getAnnotatedElement();
        result = result * 59 + ($annotatedElement == null ? 43 : $annotatedElement.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        ValueResolver $valueResolver = this.getValueResolver();
        result = result * 59 + ($valueResolver == null ? 43 : $valueResolver.hashCode());
        ClassToImplCache $implCache = this.implCache;
        result = result * 59 + ($implCache == null ? 43 : $implCache.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NodeBindingContext(annotatedElement=" + this.getAnnotatedElement() + ", defaultValue=" + this.getDefaultValue() + ", valueResolver=" + this.getValueResolver() + ", implCache=" + this.implCache + ")";
    }

    @Generated
    public NodeBindingContext withAnnotatedElement(AnnotatedElement annotatedElement) {
        return this.annotatedElement == annotatedElement ? this : new NodeBindingContext(annotatedElement, this.defaultValue, this.valueResolver, this.implCache);
    }

    @Generated
    public NodeBindingContext withDefaultValue(String defaultValue) {
        return this.defaultValue == defaultValue ? this : new NodeBindingContext(this.annotatedElement, defaultValue, this.valueResolver, this.implCache);
    }

    @Generated
    public NodeBindingContext withValueResolver(@NonNull ValueResolver valueResolver) {
        if (valueResolver == null) {
            throw new NullPointerException("valueResolver is marked non-null but is null");
        }
        return this.valueResolver == valueResolver ? this : new NodeBindingContext(this.annotatedElement, this.defaultValue, valueResolver, this.implCache);
    }
}

