/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.collection;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBindingFactory;
import ch.kk7.confij.binding.ConfijDefinitionException;
import ch.kk7.confij.binding.collection.CollectionBinding;
import ch.kk7.confij.binding.collection.CollectionBuilder;
import ch.kk7.confij.common.Util;
import com.fasterxml.classmate.ResolvedType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class CollectionBindingFactory
implements ConfigBindingFactory<CollectionBinding> {
    private final Function<ResolvedType, ? extends CollectionBuilder> builderFactory;

    public CollectionBindingFactory() {
        this(CollectionBuilder::new);
    }

    public CollectionBindingFactory(Function<ResolvedType, ? extends CollectionBuilder> builderFactory) {
        this.builderFactory = builderFactory;
    }

    @NonNull
    public static ResolvedType collectionComponentType(ResolvedType type) {
        List typeParameters = type.typeParametersFor(Collection.class);
        if (typeParameters.size() != 1) {
            throw new IllegalStateException("Collection should always have 1 generic type, but found: " + typeParameters);
        }
        ResolvedType componentType = (ResolvedType)typeParameters.get(0);
        if (Util.rawObjectType.equals((Object)componentType)) {
            throw new ConfijDefinitionException("Failed to determine the generic component type of Collection<?> for {}. There is no upper bound for this generic parameter but we cannot bind to Object. " + type, new Object[0]);
        }
        return componentType;
    }

    @Override
    public Optional<CollectionBinding> maybeCreate(BindingType bindingType, ConfigBinder configBinder) {
        ResolvedType type = bindingType.getResolvedType();
        if (type.isInstanceOf(Collection.class)) {
            ResolvedType componentType = CollectionBindingFactory.collectionComponentType(type);
            CollectionBuilder builder = this.builderFactory.apply(type);
            return Optional.of(new CollectionBinding(builder, bindingType.bindingFor(componentType), configBinder));
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "CollectionBindingFactory(builderFactory=" + this.builderFactory + ")";
    }
}

