/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.map;

import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.map.MapBuilder;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeBindingContext;
import ch.kk7.confij.tree.NodeDefinition;
import java.util.ArrayList;
import java.util.Map;

public class MapBinding<T>
implements ConfigBinding<Map<String, T>> {
    private final MapBuilder builder;
    private final ConfigBinding<T> componentDescription;

    public MapBinding(MapBuilder builder, BindingType bindingType, ConfigBinder configBinder) {
        this.builder = builder;
        this.componentDescription = configBinder.toConfigBinding(bindingType);
    }

    @Override
    public NodeDefinition.NodeDefinitionMap describe(NodeBindingContext nodeBindingContext) {
        return NodeDefinition.NodeDefinitionMap.anyKeyMap(nodeBindingContext, this.componentDescription.describe(nodeBindingContext));
    }

    @Override
    public BindingResult<Map<String, T>> bind(ConfijNode config) {
        ArrayList bindingResultChildren = new ArrayList();
        Map map = this.builder.newInstance();
        config.getChildren().forEach((key, childConfig) -> {
            BindingResult<T> childValue = this.componentDescription.bind((ConfijNode)childConfig);
            map.put(key, childValue.getValue());
            bindingResultChildren.add(childValue);
        });
        Map hardenedMap = this.builder.tryHarden(map);
        return BindingResult.of(hardenedMap, config, bindingResultChildren);
    }
}

