/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

public class DateTimeMapper
implements ValueMapperFactory {
    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        Class type = bindingType.getResolvedType().getErasedType();
        if (type.equals(ZonedDateTime.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            return Optional.of(x -> ZonedDateTime.parse(x, formatter));
        }
        if (type.equals(OffsetDateTime.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return Optional.of(x -> OffsetDateTime.parse(x, formatter));
        }
        if (type.equals(Instant.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_INSTANT);
            return Optional.of(x -> formatter.parse((CharSequence)x, Instant::from));
        }
        if (type.equals(LocalDateTime.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return Optional.of(x -> LocalDateTime.parse(x, formatter));
        }
        if (type.equals(LocalDate.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_LOCAL_DATE);
            return Optional.of(x -> LocalDate.parse(DateTimeMapper.dateHack00(x), formatter));
        }
        if (type.equals(LocalTime.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_LOCAL_TIME);
            return Optional.of(x -> LocalTime.parse(x, formatter));
        }
        if (type.equals(Date.class)) {
            DateTimeFormatter formatter = this.newDateTimeFormatter(bindingType, DateTimeFormatter.ISO_INSTANT);
            return Optional.of(x -> Date.from(formatter.parse((CharSequence)x, Instant::from)));
        }
        return Optional.empty();
    }

    protected static String dateHack00(String str) {
        String zeroTime = "T00:00:00Z";
        if (str.endsWith(zeroTime)) {
            return str.substring(0, str.length() - zeroTime.length());
        }
        return str;
    }

    protected DateTimeFormatter newDateTimeFormatter(BindingType bindingType, DateTimeFormatter defaultFormatter) {
        return bindingType.getBindingContext().getFactoryConfigFor(DateTimeMapper.class).filter(DateTime.class::isInstance).map(DateTime.class::cast).map(annon -> {
            DateTimeFormatter formatter = annon.value().isEmpty() ? defaultFormatter : DateTimeFormatter.ofPattern(annon.value());
            Locale formatLang = Locale.forLanguageTag(annon.lang());
            return formatter.withLocale(formatLang);
        }).orElse(defaultFormatter);
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=DateTimeMapper.class)
    public static @interface DateTime {
        public String value() default "";

        public String lang() default "us";
    }
}

