/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.common;

import ch.kk7.confij.common.ConfijException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class ClassToImplCache {
    private final Map<Class<?>, Object> instances = new HashMap();

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.instances.computeIfAbsent(clazz, k -> {
            try {
                Constructor constructor = k.getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ConfijException("unable to instantiate: " + k, e);
            }
        });
    }

    public void put(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.instances.put(instance.getClass(), instance);
    }

    public <T> T getInstance(Class<? extends T> clazz, Class<T> asClass) {
        return asClass.cast(this.getInstance(clazz));
    }

    @Generated
    public String toString() {
        return "ClassToImplCache(instances=" + this.instances + ")";
    }
}

