/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.ServiceLoaderPriority;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.template.ValueResolver;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class URLResource
implements ConfijResource {
    @NonNull
    private final String urlTemplate;
    @NonNull
    private final String charsetTemplate;

    public static URLResource ofUrl(String urlTemplate) {
        return new URLResource(urlTemplate, ConfijResource.Defaults.CHARSET_NAME);
    }

    public static URLResource ofUrl(URL url) {
        return URLResource.ofUrl(url.toExternalForm());
    }

    public URLResource withCharset(Charset charset) {
        return this.withCharsetTemplate(charset.name());
    }

    @Override
    public Stream<ConfijResource.ResourceContent> read(ValueResolver.StringResolver resolver) {
        String urlStr = resolver.resolve(this.urlTemplate);
        String charsetStr = resolver.resolve(this.charsetTemplate);
        return Stream.of(URLResource.readUrl(urlStr, charsetStr)).map(x -> new ConfijResource.ResourceContent((String)x, urlStr));
    }

    protected static String readUrl(String urlStr, String charsetStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url: " + urlStr, e);
        }
        Charset charset = Charset.forName(charsetStr);
        return URLResource.readUrl(url, charset);
    }

    protected static String readUrl(URL url, Charset charset) {
        String string;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                Scanner s = new Scanner(inputStream, charset.name()).useDelimiter("\\A");
                String string2 = string = s.hasNext() ? s.next() : "";
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ConfijSourceFetchingException.unableToFetch(url.toString(), "cannot read", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @NonNull
    @Generated
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    @NonNull
    @Generated
    public String getCharsetTemplate() {
        return this.charsetTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLResource)) {
            return false;
        }
        URLResource other = (URLResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$urlTemplate = this.getUrlTemplate();
        String other$urlTemplate = other.getUrlTemplate();
        if (this$urlTemplate == null ? other$urlTemplate != null : !this$urlTemplate.equals(other$urlTemplate)) {
            return false;
        }
        String this$charsetTemplate = this.getCharsetTemplate();
        String other$charsetTemplate = other.getCharsetTemplate();
        return !(this$charsetTemplate == null ? other$charsetTemplate != null : !this$charsetTemplate.equals(other$charsetTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof URLResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $urlTemplate = this.getUrlTemplate();
        result = result * 59 + ($urlTemplate == null ? 43 : $urlTemplate.hashCode());
        String $charsetTemplate = this.getCharsetTemplate();
        result = result * 59 + ($charsetTemplate == null ? 43 : $charsetTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "URLResource(urlTemplate=" + this.getUrlTemplate() + ", charsetTemplate=" + this.getCharsetTemplate() + ")";
    }

    @Generated
    public URLResource withUrlTemplate(@NonNull String urlTemplate) {
        if (urlTemplate == null) {
            throw new NullPointerException("urlTemplate is marked non-null but is null");
        }
        return this.urlTemplate == urlTemplate ? this : new URLResource(urlTemplate, this.charsetTemplate);
    }

    @Generated
    public URLResource withCharsetTemplate(@NonNull String charsetTemplate) {
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        return this.charsetTemplate == charsetTemplate ? this : new URLResource(this.urlTemplate, charsetTemplate);
    }

    @Generated
    public URLResource(@NonNull String urlTemplate, @NonNull String charsetTemplate) {
        if (urlTemplate == null) {
            throw new NullPointerException("urlTemplate is marked non-null but is null");
        }
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        this.urlTemplate = urlTemplate;
        this.charsetTemplate = charsetTemplate;
    }

    @AutoService(value={ConfijAnyResource.class})
    public static class AnyURLResource
    implements ConfijAnyResource,
    ServiceLoaderPriority {
        private static Optional<URL> maybeUrl(String maybeUrl) {
            try {
                return Optional.of(new URL(maybeUrl));
            }
            catch (MalformedURLException e) {
                return Optional.empty();
            }
        }

        @Override
        public int getPriority() {
            return -100;
        }

        public Optional<URLResource> maybeHandle(String pathTemplate) {
            return AnyURLResource.maybeUrl(pathTemplate).map(URLResource::ofUrl);
        }

        @Generated
        public String toString() {
            return "URLResource.AnyURLResource()";
        }
    }
}

