/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.annotation.Key;
import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.intf.InterfaceProxyBuilder;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import ch.kk7.confij.shadow.com.fasterxml.classmate.members.ResolvedMethod;
import ch.kk7.confij.shadow.com.fasterxml.classmate.types.ResolvedInterfaceType;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeBindingContext;
import ch.kk7.confij.tree.NodeDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class InterfaceBinding<T>
implements ConfigBinding<T> {
    private final Map<String, AttributeInformation> siblingsByName;
    private final InterfaceProxyBuilder<T> interfaceBuilder;

    public InterfaceBinding(BindingType bindingType, ConfigBinder configBinder) {
        ResolvedType baseType = bindingType.getResolvedType();
        if (!(baseType instanceof ResolvedInterfaceType)) {
            throw new IllegalArgumentException("expected type " + baseType + " to be a " + ResolvedInterfaceType.class);
        }
        BindingContext classBindingContext = bindingType.getBindingContext().settingsFor(baseType.getErasedType(), false);
        this.siblingsByName = new LinkedHashMap<String, AttributeInformation>();
        this.interfaceBuilder = new InterfaceProxyBuilder((ResolvedInterfaceType)baseType);
        for (ResolvedMethod method : this.interfaceBuilder.getAllowedMethods()) {
            BindingType methodBindingType = bindingType.bindingFor(method.getReturnType(), classBindingContext.settingsFor((AnnotatedElement)method.getRawMember(), true));
            ConfigBinding<?> methodDescription = configBinder.toConfigBinding(methodBindingType);
            String configKey = AnnotationUtil.findAnnotation((AnnotatedElement)method.getRawMember(), Key.class).map(Key::value).orElse(method.getName());
            this.siblingsByName.put(configKey, new AttributeInformation(methodDescription, method));
        }
    }

    @Override
    public NodeDefinition.NodeDefinitionMap describe(NodeBindingContext nodeBindingContext) {
        NodeBindingContext settingsForThisClass = nodeBindingContext.settingsFor(this.interfaceBuilder.getType().getErasedType());
        return NodeDefinition.NodeDefinitionMap.fixedKeysMap(settingsForThisClass, this.siblingsByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AttributeInformation)e.getValue()).getDescription().describe(settingsForThisClass.settingsFor((AnnotatedElement)((AttributeInformation)e.getValue()).getMethod().getRawMember())))));
    }

    @Override
    public BindingResult<T> bind(ConfijNode config) {
        Map<String, ConfijNode> childConfigs = config.getChildren();
        ArrayList bindingResultChildren = new ArrayList();
        InterfaceProxyBuilder.ValidatingProxyBuilder proxyBuilder = this.interfaceBuilder.builder();
        this.siblingsByName.forEach((key, siblingDescription) -> {
            BindingResult<?> siblingBindingResult = siblingDescription.getDescription().bind((ConfijNode)childConfigs.get(key));
            Object siblingValue = siblingBindingResult.getValue();
            ResolvedMethod method = siblingDescription.getMethod();
            if (((Method)method.getRawMember()).isDefault() && this.isEmpty(siblingValue)) {
                return;
            }
            proxyBuilder.methodToValue(method, siblingValue);
            bindingResultChildren.add(siblingBindingResult);
        });
        Object result = proxyBuilder.build();
        return BindingResult.of(result, config, bindingResultChildren);
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    @Generated
    public String toString() {
        return "InterfaceBinding(siblingsByName=" + this.siblingsByName + ", interfaceBuilder=" + this.interfaceBuilder + ")";
    }

    public static final class AttributeInformation {
        private final ConfigBinding<?> description;
        private final ResolvedMethod method;

        @Generated
        public AttributeInformation(ConfigBinding<?> description, ResolvedMethod method) {
            this.description = description;
            this.method = method;
        }

        @Generated
        public ConfigBinding<?> getDescription() {
            return this.description;
        }

        @Generated
        public ResolvedMethod getMethod() {
            return this.method;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeInformation)) {
                return false;
            }
            AttributeInformation other = (AttributeInformation)o;
            ConfigBinding<?> this$description = this.getDescription();
            ConfigBinding<?> other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            ResolvedMethod this$method = this.getMethod();
            ResolvedMethod other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConfigBinding<?> $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            ResolvedMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InterfaceBinding.AttributeInformation(description=" + this.getDescription() + ", method=" + this.getMethod() + ")";
        }
    }
}

