/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.DateTimeMapper;
import ch.kk7.confij.binding.values.DurationMapper;
import ch.kk7.confij.binding.values.EnumMapper;
import ch.kk7.confij.binding.values.ExplicitMapper;
import ch.kk7.confij.binding.values.OptionalMapper;
import ch.kk7.confij.binding.values.PeriodMapper;
import ch.kk7.confij.binding.values.PrimitiveMapperFactory;
import ch.kk7.confij.binding.values.SoloConstructorMapper;
import ch.kk7.confij.binding.values.StaticFunctionMapper;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

@FunctionalInterface
public interface ValueMapperFactory {
    public static <T> ValueMapperFactory always(@NonNull ValueMapperInstance<T> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return bindingType -> Optional.of(mapper);
    }

    public static <T> ValueMapperFactory forClass(@NonNull ValueMapperInstance<T> mapper, @NonNull Class<T> forClass) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (forClass == null) {
            throw new NullPointerException("forClass is marked non-null but is null");
        }
        return bindingType -> {
            if (bindingType.getResolvedType().getErasedType().equals(forClass)) {
                return Optional.of(mapper);
            }
            return Optional.empty();
        };
    }

    public static List<ValueMapperFactory> defaultFactories() {
        return Arrays.asList(ExplicitMapper.forString(), new PrimitiveMapperFactory(), new OptionalMapper(), ExplicitMapper.forFile(), ExplicitMapper.forPath(), new EnumMapper(), new DurationMapper(), new PeriodMapper(), new DateTimeMapper(), new StaticFunctionMapper(), new SoloConstructorMapper());
    }

    public Optional<ValueMapperInstance<?>> maybeForType(BindingType var1);
}

