/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.env;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.any.ConfijAnySource;
import ch.kk7.confij.source.format.PropertiesFormat;
import ch.kk7.confij.tree.ConfijNode;
import com.google.auto.service.AutoService;
import java.util.Optional;
import lombok.Generated;

public class EnvvarSource
extends PropertiesFormat
implements ConfijSource {
    private Object deepMap;

    protected EnvvarSource(String prefix) {
        super("_", prefix);
    }

    public static EnvvarSource withPrefix(String prefix) {
        return new EnvvarSource(prefix);
    }

    @Override
    public void override(ConfijNode rootNode) {
        if (this.deepMap == null) {
            this.deepMap = this.flatToNestedMapWithPrefix(System.getenv());
        }
        this.overrideWithDeepMap(rootNode, this.deepMap);
    }

    @Override
    @Generated
    public String toString() {
        return "EnvvarSource(deepMap=" + this.deepMap + ")";
    }

    @AutoService(value={ConfijAnySource.class})
    public static class EnvvarAnySource
    implements ConfijAnySource {
        public static final String SCHEME = "env";

        @Override
        public Optional<ConfijSource> fromURI(String pathTemplate) {
            return Util.getScheme(pathTemplate).filter(scheme -> scheme.equals(SCHEME)).map(scheme -> {
                String path = Util.getSchemeSpecificPart(pathTemplate);
                return EnvvarSource.withPrefix(path);
            });
        }

        @Generated
        public String toString() {
            return "EnvvarSource.EnvvarAnySource()";
        }
    }
}

