/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline.reload;

import ch.kk7.confij.binding.BindingResult;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

@FunctionalInterface
public interface ConfijReloadHandler<X> {
    public void onReload(ReloadEvent<X> var1);

    public static final class ReloadEvent<X> {
        @NonNull
        private final Instant timestamp;
        private final X oldValue;
        private final X newValue;
        @NonNull
        private final URI eventPath;
        @NonNull
        private final Set<URI> changedPaths;

        public static <X> ReloadEvent<X> newOf(Instant timestamp, BindingResult<X> oldBindingResult, BindingResult<X> newBindingResult) {
            URI selfUri = newBindingResult.getNode().getUri();
            return new ReloadEvent<X>(timestamp, oldBindingResult.getValue(), newBindingResult.getValue(), selfUri, Collections.singleton(selfUri));
        }

        public static <X> ReloadEvent<X> merge(Instant timestamp, BindingResult<X> oldBindingResult, BindingResult<X> newBindingResult, Set<ReloadEvent<?>> childChanges) {
            URI selfUri = newBindingResult.getNode().getUri();
            return new ReloadEvent<X>(timestamp, oldBindingResult.getValue(), newBindingResult.getValue(), selfUri, childChanges.stream().flatMap(x -> x.getChangedPaths().stream()).collect(Collectors.toSet()));
        }

        public static <X> ReloadEvent<X> removed(Instant timestamp, BindingResult<X> oldBindingResult) {
            URI selfUri = oldBindingResult.getNode().getUri();
            return new ReloadEvent<Object>(timestamp, oldBindingResult.getValue(), null, selfUri, Collections.singleton(selfUri));
        }

        public static <X> ReloadEvent<X> added(Instant timestamp, BindingResult<X> newBindingResult) {
            URI selfUri = newBindingResult.getNode().getUri();
            return new ReloadEvent<Object>(timestamp, null, newBindingResult.getValue(), selfUri, Collections.singleton(selfUri));
        }

        @Generated
        public ReloadEvent(@NonNull Instant timestamp, X oldValue, X newValue, @NonNull URI eventPath, @NonNull Set<URI> changedPaths) {
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            if (eventPath == null) {
                throw new NullPointerException("eventPath is marked non-null but is null");
            }
            if (changedPaths == null) {
                throw new NullPointerException("changedPaths is marked non-null but is null");
            }
            this.timestamp = timestamp;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.eventPath = eventPath;
            this.changedPaths = changedPaths;
        }

        @NonNull
        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public X getOldValue() {
            return this.oldValue;
        }

        @Generated
        public X getNewValue() {
            return this.newValue;
        }

        @NonNull
        @Generated
        public URI getEventPath() {
            return this.eventPath;
        }

        @NonNull
        @Generated
        public Set<URI> getChangedPaths() {
            return this.changedPaths;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReloadEvent)) {
                return false;
            }
            ReloadEvent other = (ReloadEvent)o;
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            X this$oldValue = this.getOldValue();
            X other$oldValue = other.getOldValue();
            if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
                return false;
            }
            X this$newValue = this.getNewValue();
            X other$newValue = other.getNewValue();
            if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
                return false;
            }
            URI this$eventPath = this.getEventPath();
            URI other$eventPath = other.getEventPath();
            if (this$eventPath == null ? other$eventPath != null : !((Object)this$eventPath).equals(other$eventPath)) {
                return false;
            }
            Set<URI> this$changedPaths = this.getChangedPaths();
            Set<URI> other$changedPaths = other.getChangedPaths();
            return !(this$changedPaths == null ? other$changedPaths != null : !((Object)this$changedPaths).equals(other$changedPaths));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            X $oldValue = this.getOldValue();
            result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
            X $newValue = this.getNewValue();
            result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
            URI $eventPath = this.getEventPath();
            result = result * 59 + ($eventPath == null ? 43 : ((Object)$eventPath).hashCode());
            Set<URI> $changedPaths = this.getChangedPaths();
            result = result * 59 + ($changedPaths == null ? 43 : ((Object)$changedPaths).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfijReloadHandler.ReloadEvent(timestamp=" + this.getTimestamp() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", eventPath=" + this.getEventPath() + ", changedPaths=" + this.getChangedPaths() + ")";
        }
    }
}

