/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResource;
import ch.kk7.confij.template.ValueResolver;
import com.google.auto.service.AutoService;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class ClasspathResource
implements ConfijResource {
    @NonNull
    private final String nameTemplate;
    @NonNull
    private final String charsetTemplate;
    private final Class<?> relativeClass;
    private final ClassLoader relativeClassLoader;

    public ClasspathResource relativeTo(ClassLoader relativeClassLoader) {
        return this.withRelativeClassLoader(relativeClassLoader);
    }

    public ClasspathResource relativeTo(Class<?> relativeClass) {
        return this.withRelativeClass(relativeClass);
    }

    @Deprecated
    public ClasspathResource withClassloaderOf(Class<?> relativeClass) {
        return this.relativeTo(relativeClass);
    }

    public ClasspathResource withCharset(Charset charset) {
        return this.withCharsetTemplate(charset.name());
    }

    public static ClasspathResource ofName(String nameTemplate) {
        return new ClasspathResource(nameTemplate, ConfijResource.Defaults.CHARSET_NAME, null, Thread.currentThread().getContextClassLoader());
    }

    @NonNull
    protected URL asUrl(String name) {
        if (this.relativeClass != null) {
            URL url = this.relativeClass.getResource(name);
            if (url == null) {
                throw ConfijSourceFetchingException.unableToFetch(name, "no such file on classpath relative to class " + this.relativeClass.getName(), new Object[0]);
            }
            return url;
        }
        URL url = this.relativeClassLoader.getResource(name);
        if (url == null) {
            throw ConfijSourceFetchingException.unableToFetch(name, "no such file on classpath of classloader" + this.relativeClassLoader, new Object[0]);
        }
        return url;
    }

    @Override
    public Stream<ConfijResource.ResourceContent> read(ValueResolver.StringResolver resolver) {
        String name = resolver.resolve(this.nameTemplate);
        Charset charset = Charset.forName(resolver.resolve(this.charsetTemplate));
        URL classpathUrl = this.asUrl(name);
        return Stream.of(new ConfijResource.ResourceContent(URLResource.readUrl(classpathUrl, charset), name));
    }

    @Generated
    public ClasspathResource(@NonNull String nameTemplate, @NonNull String charsetTemplate, Class<?> relativeClass, ClassLoader relativeClassLoader) {
        if (nameTemplate == null) {
            throw new NullPointerException("nameTemplate is marked non-null but is null");
        }
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        this.nameTemplate = nameTemplate;
        this.charsetTemplate = charsetTemplate;
        this.relativeClass = relativeClass;
        this.relativeClassLoader = relativeClassLoader;
    }

    @NonNull
    @Generated
    public String getNameTemplate() {
        return this.nameTemplate;
    }

    @NonNull
    @Generated
    public String getCharsetTemplate() {
        return this.charsetTemplate;
    }

    @Generated
    public Class<?> getRelativeClass() {
        return this.relativeClass;
    }

    @Generated
    public ClassLoader getRelativeClassLoader() {
        return this.relativeClassLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClasspathResource)) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nameTemplate = this.getNameTemplate();
        String other$nameTemplate = other.getNameTemplate();
        if (this$nameTemplate == null ? other$nameTemplate != null : !this$nameTemplate.equals(other$nameTemplate)) {
            return false;
        }
        String this$charsetTemplate = this.getCharsetTemplate();
        String other$charsetTemplate = other.getCharsetTemplate();
        if (this$charsetTemplate == null ? other$charsetTemplate != null : !this$charsetTemplate.equals(other$charsetTemplate)) {
            return false;
        }
        Class<?> this$relativeClass = this.getRelativeClass();
        Class<?> other$relativeClass = other.getRelativeClass();
        if (this$relativeClass == null ? other$relativeClass != null : !this$relativeClass.equals(other$relativeClass)) {
            return false;
        }
        ClassLoader this$relativeClassLoader = this.getRelativeClassLoader();
        ClassLoader other$relativeClassLoader = other.getRelativeClassLoader();
        return !(this$relativeClassLoader == null ? other$relativeClassLoader != null : !this$relativeClassLoader.equals(other$relativeClassLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClasspathResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nameTemplate = this.getNameTemplate();
        result = result * 59 + ($nameTemplate == null ? 43 : $nameTemplate.hashCode());
        String $charsetTemplate = this.getCharsetTemplate();
        result = result * 59 + ($charsetTemplate == null ? 43 : $charsetTemplate.hashCode());
        Class<?> $relativeClass = this.getRelativeClass();
        result = result * 59 + ($relativeClass == null ? 43 : $relativeClass.hashCode());
        ClassLoader $relativeClassLoader = this.getRelativeClassLoader();
        result = result * 59 + ($relativeClassLoader == null ? 43 : $relativeClassLoader.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClasspathResource(nameTemplate=" + this.getNameTemplate() + ", charsetTemplate=" + this.getCharsetTemplate() + ", relativeClass=" + this.getRelativeClass() + ", relativeClassLoader=" + this.getRelativeClassLoader() + ")";
    }

    @Generated
    public ClasspathResource withCharsetTemplate(@NonNull String charsetTemplate) {
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        return this.charsetTemplate == charsetTemplate ? this : new ClasspathResource(this.nameTemplate, charsetTemplate, this.relativeClass, this.relativeClassLoader);
    }

    @Generated
    protected ClasspathResource withRelativeClass(Class<?> relativeClass) {
        return this.relativeClass == relativeClass ? this : new ClasspathResource(this.nameTemplate, this.charsetTemplate, relativeClass, this.relativeClassLoader);
    }

    @Generated
    protected ClasspathResource withRelativeClassLoader(ClassLoader relativeClassLoader) {
        return this.relativeClassLoader == relativeClassLoader ? this : new ClasspathResource(this.nameTemplate, this.charsetTemplate, this.relativeClass, relativeClassLoader);
    }

    @AutoService(value={ConfijAnyResource.class})
    public static class AnyClasspathResource
    implements ConfijAnyResource {
        public static final String SCHEME = "classpath";

        public Optional<ClasspathResource> maybeHandle(String pathTemplate) {
            return Util.getScheme(pathTemplate).filter(scheme -> scheme.equals(SCHEME)).map(scheme -> {
                String path = Util.getSchemeSpecificPart(pathTemplate);
                return ClasspathResource.ofName(path);
            });
        }

        @Generated
        public String toString() {
            return "ClasspathResource.AnyClasspathResource()";
        }
    }
}

