/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.collection;

import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.collection.CollectionBuilder;
import ch.kk7.confij.binding.collection.CollectionUtil;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeBindingContext;
import ch.kk7.confij.tree.NodeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionBinding<T>
implements ConfigBinding<Collection<T>> {
    private final CollectionBuilder builder;
    private final ConfigBinding<T> componentDescription;

    public CollectionBinding(CollectionBuilder builder, BindingType componentBindingType, ConfigBinder configBinder) {
        this.builder = builder;
        this.componentDescription = configBinder.toConfigBinding(componentBindingType);
    }

    @Override
    public NodeDefinition.NodeDefinitionList describe(NodeBindingContext nodeBindingContext) {
        return new NodeDefinition.NodeDefinitionList(nodeBindingContext, this.componentDescription.describe(nodeBindingContext));
    }

    @Override
    public BindingResult<Collection<T>> bind(ConfijNode config) {
        ArrayList bindingResultChildren = new ArrayList();
        List<ConfijNode> childNodes = CollectionUtil.childrenAsContinuousList(config);
        Collection collection = this.builder.newInstance();
        for (ConfijNode childNode : childNodes) {
            BindingResult<T> listItem = this.componentDescription.bind(childNode);
            collection.add(listItem.getValue());
            bindingResultChildren.add(listItem);
        }
        return BindingResult.of(this.builder.tryHarden(collection), config, bindingResultChildren);
    }
}

