/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.any;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.any.ConfijAnyFormat;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.source.resource.ConfijResource;
import java.util.List;
import java.util.Optional;

public interface ServiceLoaderSourceAware {
    public static final List<ConfijAnyResource> supportedResources = ServiceLoaderUtil.requireInstancesOf(ConfijAnyResource.class);
    public static final List<ConfijAnyFormat> supportedFormats = ServiceLoaderUtil.requireInstancesOf(ConfijAnyFormat.class);

    default public ConfijResource getDynamicResource(String pathTemplate) {
        return supportedResources.stream().map(r -> r.maybeHandle(pathTemplate)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ConfijSourceException("failed to find a {} who can handle '{}', available are: {}", ConfijAnyResource.class.getSimpleName(), pathTemplate, supportedResources));
    }

    default public ConfijFormat getDynamicFormat(String pathTemplate) {
        return supportedFormats.stream().map(s -> s.maybeHandle(pathTemplate)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ConfijSourceException("failed to find a {} who can handle '{}', available are: {}", ConfijAnyFormat.class.getSimpleName(), pathTemplate, supportedFormats));
    }
}

