/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class Base64Mapper
implements ValueMapperFactory {
    public Base64.Decoder getDecoder(BindingType bindingType) {
        return bindingType.getBindingContext().getFactoryConfigFor(Base64Mapper.class).filter(Base64.class::isInstance).map(Base64.class::cast).orElse(AnnonHolder.class.getAnnotation(Base64.class)).decoder().getDecoder();
    }

    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        ResolvedType componentType;
        ResolvedType type = bindingType.getResolvedType();
        if (type.isArray() && (componentType = type.getArrayElementType()).isInstanceOf(Byte.TYPE)) {
            return Optional.of(new Base64MapperInstance<byte[]>(this.getDecoder(bindingType), x -> x));
        }
        if (type.isInstanceOf(List.class) && (componentType = (ResolvedType)type.typeParametersFor(List.class).get(0)).isInstanceOf(Byte.class)) {
            return Optional.of(new Base64MapperInstance<List>(this.getDecoder(bindingType), arr -> {
                ArrayList<Byte> result = new ArrayList<Byte>(((byte[])arr).length);
                for (byte b : arr) {
                    result.add(b);
                }
                return result;
            }));
        }
        return Optional.empty();
    }

    public static class Base64MapperInstance<T>
    implements ValueMapperInstance<T> {
        @NonNull
        private final Base64.Decoder decoder;
        @NonNull
        private final Function<byte[], T> mapping;

        @Override
        public T fromString(String string) {
            return this.mapping.apply(this.decoder.decode(string));
        }

        @Generated
        public Base64MapperInstance(@NonNull Base64.Decoder decoder, @NonNull Function<byte[], T> mapping) {
            if (decoder == null) {
                throw new NullPointerException("decoder is marked non-null but is null");
            }
            if (mapping == null) {
                throw new NullPointerException("mapping is marked non-null but is null");
            }
            this.decoder = decoder;
            this.mapping = mapping;
        }
    }

    @Base64
    private static final class AnnonHolder {
        private AnnonHolder() {
        }
    }

    public static enum Base64Decoder {
        RFC4648,
        RFC4648_URLSAFE,
        RFC2045;


        public Base64.Decoder getDecoder() {
            switch (this) {
                case RFC4648: {
                    return java.util.Base64.getDecoder();
                }
                case RFC4648_URLSAFE: {
                    return java.util.Base64.getUrlDecoder();
                }
                case RFC2045: {
                    return java.util.Base64.getMimeDecoder();
                }
            }
            throw new IllegalStateException("unknown decoder for " + (Object)((Object)this));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=Base64Mapper.class)
    public static @interface Base64 {
        public Base64Decoder decoder() default Base64Decoder.RFC4648;
    }
}

