/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline.reload;

import ch.kk7.confij.ConfijBuilder;
import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.common.ConfijException;
import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.pipeline.reload.ConfijReloadHandler;
import ch.kk7.confij.pipeline.reload.ConfijReloadNotifier;
import ch.kk7.confij.tree.NodeDefinition;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class ReloadNotifierImpl<T>
implements ConfijReloadNotifier<T> {
    @Generated
    private final Object $lock = new Object[0];
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(ReloadNotifierImpl.class);
    private static final Set<Class<?>> NON_UNIQUE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Integer.class, Long.class, Double.class, Float.class, Character.class));
    private final Map<URI, List<ConfijReloadHandler<?>>> registeredHandlers = new LinkedHashMap();
    private BindingResult<T> lastBindingResult = null;

    protected static Map<URI, BindingResult<?>> toChildMappings(BindingResult<?> bindingResult) {
        return bindingResult.getChildren().stream().collect(Collectors.toMap(x -> x.getNode().getUri(), x -> x, (x1, x2) -> x1, LinkedHashMap::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ConfijReloadHandler.ReloadEvent<T>> configReloaded(@NonNull BindingResult<T> newBindingResult) {
        Object object = this.$lock;
        synchronized (object) {
            Optional<ConfijReloadHandler.ReloadEvent<ConfijReloadHandler.ReloadEvent>> result;
            if (newBindingResult == null) {
                throw new NullPointerException("newBindingResult is marked non-null but is null");
            }
            if (this.lastBindingResult == null) {
                result = Optional.empty();
            } else {
                Instant timestamp = Instant.now();
                result = this.notifyAllChangedValues(timestamp, this.lastBindingResult, newBindingResult);
                result.ifPresent(event -> LOGGER.info("configuration change (@{}) detected changes in {}", timestamp, event.getChangedPaths()));
            }
            this.lastBindingResult = newBindingResult;
            return result;
        }
    }

    protected void maybeNotify(ConfijReloadHandler.ReloadEvent reloadEvent) {
        Optional.ofNullable(this.registeredHandlers.get(reloadEvent.getEventPath())).ifPresent(x -> x.forEach(handler -> handler.onReload(reloadEvent)));
    }

    protected <X> Optional<ConfijReloadHandler.ReloadEvent<X>> notifyAllChangedValues(Instant timestamp, BindingResult<X> oldBindingResult, BindingResult<X> newBindingResult) {
        if (oldBindingResult.getNode().getConfig().isValueHolder()) {
            boolean isSameConfigValue = Objects.equals(oldBindingResult.getNode().getValue(), newBindingResult.getNode().getValue());
            if (isSameConfigValue) {
                return Optional.empty();
            }
            return Optional.of(ConfijReloadHandler.ReloadEvent.newOf(timestamp, oldBindingResult, newBindingResult));
        }
        Map<URI, BindingResult<X>> oldChildMappings = ReloadNotifierImpl.toChildMappings(oldBindingResult);
        Map newChildMappings = ReloadNotifierImpl.toChildMappings(newBindingResult);
        LinkedHashSet childReloadEvents = new LinkedHashSet();
        oldChildMappings.forEach((oldUri, oldChildBindingResult) -> {
            BindingResult newChildBindingResult = (BindingResult)newChildMappings.get(oldUri);
            if (newChildBindingResult == null) {
                childReloadEvents.add(ConfijReloadHandler.ReloadEvent.removed(timestamp, oldChildBindingResult));
            } else {
                this.notifyAllChangedValues(timestamp, (BindingResult)oldChildBindingResult, newChildBindingResult).ifPresent(x -> childReloadEvents.add((ConfijReloadHandler.ReloadEvent)x));
                newChildMappings.remove(oldUri);
            }
        });
        newChildMappings.forEach((uri, newChildBindingResult) -> childReloadEvents.add(ConfijReloadHandler.ReloadEvent.added(timestamp, newChildBindingResult)));
        if (childReloadEvents.isEmpty()) {
            return Optional.empty();
        }
        childReloadEvents.forEach(this::maybeNotify);
        ConfijReloadHandler.ReloadEvent<X> combinedReloadEvent = ConfijReloadHandler.ReloadEvent.merge(timestamp, oldBindingResult, newBindingResult, childReloadEvents);
        this.maybeNotify(combinedReloadEvent);
        return Optional.of(combinedReloadEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRootReloadHandler(@NonNull ConfijReloadHandler<T> reloadHandler) {
        Object object = this.$lock;
        synchronized (object) {
            if (reloadHandler == null) {
                throw new NullPointerException("reloadHandler is marked non-null but is null");
            }
            this.registerReloadHandlerOnUri(this.getLastBindingResult().getNode().getUri(), reloadHandler);
        }
    }

    @Override
    public <X> void registerReloadHandler(@NonNull ConfijReloadHandler<X> childReloadHandler, @NonNull Object parent, String childPath, String ... childPaths) {
        if (childReloadHandler == null) {
            throw new NullPointerException("childReloadHandler is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.registerReloadHandlerInternal(childReloadHandler, parent, (String[])Stream.concat(Stream.of(childPath), Stream.of(childPaths)).toArray(String[]::new));
    }

    @Override
    public <X> void registerReloadHandler(@NonNull ConfijReloadHandler<X> reloadHandler, @NonNull X onConfigObject) {
        if (reloadHandler == null) {
            throw new NullPointerException("reloadHandler is marked non-null but is null");
        }
        if (onConfigObject == null) {
            throw new NullPointerException("onConfigObject is marked non-null but is null");
        }
        this.registerReloadHandlerInternal(reloadHandler, onConfigObject, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerReloadHandlerInternal(ConfijReloadHandler<?> reloadHandler, Object onConfigObject, String ... childPaths) {
        Object object = this.$lock;
        synchronized (object) {
            URI uriOfObj;
            if (NON_UNIQUE_TYPES.contains(onConfigObject.getClass())) {
                throw new ConfijException("it is unsafe to register a ReloadHandler on {} (type {}). all primitive types [int, boolean,...] as well as its boxing counterparts {} might not be unique and therefore ConfiJ might not recognize the correct Object you meant.", onConfigObject.getClass().getSimpleName(), NON_UNIQUE_TYPES.stream().map(Class::getSimpleName).collect(Collectors.toList()));
            }
            URI targetUri = uriOfObj = this.mustFindUniqueConfigObject(onConfigObject);
            for (String pathPart : childPaths) {
                targetUri = targetUri.resolve(pathPart);
            }
            try {
                this.getLastBindingResult().getNode().resolve(targetUri);
            }
            catch (ConfijException e) {
                throw new ConfijException("failed to register a ReloadHandler on {}. the parent instance {} ({}) was found, however not the child instance: {}", targetUri, uriOfObj, onConfigObject, e.getMessage(), e);
            }
            this.registerReloadHandlerOnUri(targetUri, reloadHandler);
        }
    }

    @NonNull
    protected <X> URI mustFindUniqueConfigObject(X onConfigObject) {
        LinkedHashSet<BindingResult<X>> results = new LinkedHashSet<BindingResult<X>>();
        this.findSameValue(this.getLastBindingResult(), onConfigObject, results);
        if (results.isEmpty()) {
            throw new ConfijException("unknown configuration object: {} (type {}). cannot register a ReloadHandler on this instance since the same object cannot be found. Is must be an object you got using {}", onConfigObject, onConfigObject.getClass().getName(), ConfijBuilder.class + "#build()");
        }
        if (results.size() > 1) {
            throw new ConfijException("non unique configuration object {}. cannot register a reload handler on this. the following config paths are all the same instance: {}", onConfigObject, results.stream().map(x -> x.getNode().getUri()).collect(Collectors.toList()));
        }
        return ((BindingResult)results.iterator().next()).getNode().getUri();
    }

    protected <X> void registerReloadHandlerOnUri(@NonNull URI nodeURI, @NonNull ConfijReloadHandler<X> reloadHandler) {
        if (nodeURI == null) {
            throw new NullPointerException("nodeURI is marked non-null but is null");
        }
        if (reloadHandler == null) {
            throw new NullPointerException("reloadHandler is marked non-null but is null");
        }
        List registered = this.registeredHandlers.computeIfAbsent(nodeURI, x -> new ArrayList());
        if (registered.contains(reloadHandler)) {
            throw new ConfijException("this {} is already registered on path '{}': {}", ConfijReloadHandler.class.getSimpleName(), nodeURI, reloadHandler);
        }
        registered.add(reloadHandler);
    }

    protected <X> void findSameValue(BindingResult<?> current, @NonNull X onConfigObject, Set<BindingResult<X>> results) {
        if (onConfigObject == null) {
            throw new NullPointerException("onConfigObject is marked non-null but is null");
        }
        for (BindingResult<?> child : current.getChildren()) {
            this.findSameValue(child, onConfigObject, results);
        }
        if (current.getValue() == onConfigObject) {
            results.add(current);
        } else if (!results.isEmpty() && current.getNode().getConfig() instanceof NodeDefinition.NodeDefinitionList) {
            LOGGER.info("Ugh, registering a {} on a child of '{}', which is a list-like type is dangerous as is not well-defined what will happen in cases were entries are added/removed", ConfijReloadHandler.class.getSimpleName(), current.getNode().getUri());
        }
    }

    @Generated
    public Map<URI, List<ConfijReloadHandler<?>>> getRegisteredHandlers() {
        return this.registeredHandlers;
    }

    @Generated
    public BindingResult<T> getLastBindingResult() {
        return this.lastBindingResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReloadNotifierImpl)) {
            return false;
        }
        ReloadNotifierImpl other = (ReloadNotifierImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<URI, List<ConfijReloadHandler<?>>> this$registeredHandlers = this.getRegisteredHandlers();
        Map<URI, List<ConfijReloadHandler<?>>> other$registeredHandlers = other.getRegisteredHandlers();
        if (this$registeredHandlers == null ? other$registeredHandlers != null : !((Object)this$registeredHandlers).equals(other$registeredHandlers)) {
            return false;
        }
        BindingResult<T> this$lastBindingResult = this.getLastBindingResult();
        BindingResult<T> other$lastBindingResult = other.getLastBindingResult();
        return !(this$lastBindingResult == null ? other$lastBindingResult != null : !((Object)this$lastBindingResult).equals(other$lastBindingResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReloadNotifierImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<URI, List<ConfijReloadHandler<?>>> $registeredHandlers = this.getRegisteredHandlers();
        result = result * 59 + ($registeredHandlers == null ? 43 : ((Object)$registeredHandlers).hashCode());
        BindingResult<T> $lastBindingResult = this.getLastBindingResult();
        result = result * 59 + ($lastBindingResult == null ? 43 : ((Object)$lastBindingResult).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReloadNotifierImpl(registeredHandlers=" + this.getRegisteredHandlers() + ", lastBindingResult=" + this.getLastBindingResult() + ")";
    }

    @Generated
    public ReloadNotifierImpl() {
    }
}

