/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij;

import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import ch.kk7.confij.common.ConfijException;
import ch.kk7.confij.common.GenericType;
import ch.kk7.confij.common.Util;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.ConfijPipelineImpl;
import ch.kk7.confij.pipeline.reload.ConfijReloadNotifier;
import ch.kk7.confij.pipeline.reload.ConfijReloadStrategy;
import ch.kk7.confij.pipeline.reload.NeverReloadStrategy;
import ch.kk7.confij.pipeline.reload.PeriodicReloadStrategy;
import ch.kk7.confij.pipeline.reload.ReloadNotifierImpl;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.any.AnySourceImpl;
import ch.kk7.confij.source.any.FixResourceAnyFormatSource;
import ch.kk7.confij.source.any.FixResourceFixFormatSource;
import ch.kk7.confij.source.defaults.DefaultSource;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.source.logical.MaybeSource;
import ch.kk7.confij.source.logical.OrSource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.template.NoopValueResolver;
import ch.kk7.confij.template.SimpleVariableResolver;
import ch.kk7.confij.template.ValueResolver;
import ch.kk7.confij.tree.NodeBindingContext;
import ch.kk7.confij.tree.NodeDefinition;
import ch.kk7.confij.validation.ConfijValidator;
import ch.kk7.confij.validation.MultiValidator;
import ch.kk7.confij.validation.NonNullValidator;
import ch.kk7.confij.validation.ServiceLoaderValidator;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class ConfijBuilder<T> {
    private final Type forType;
    private final List<ConfijSource> sources = new ArrayList<ConfijSource>();
    private ConfijValidator<T> validator = null;
    private ConfijValidator<T> nonNullValidator = null;
    private ValueResolver valueResolver = null;
    private final ArrayList<ValueMapperFactory> valueMapperFactories = new ArrayList<ValueMapperFactory>(ValueMapperFactory.defaultFactories());
    private ConfijReloadStrategy reloadStrategy = null;
    private final ReloadNotifierImpl<T> reloadNotifier = new ReloadNotifierImpl();

    protected void lazySetDefaults() {
        this.validator = Optional.ofNullable(this.validator).orElseGet(() -> MultiValidator.of(new ServiceLoaderValidator(), Optional.ofNullable(this.nonNullValidator).orElseGet(NonNullValidator::initiallyNullable)));
        this.valueResolver = Optional.ofNullable(this.valueResolver).orElseGet(SimpleVariableResolver::new);
        this.reloadStrategy = Optional.ofNullable(this.reloadStrategy).orElseGet(NeverReloadStrategy::new);
    }

    protected ConfijBuilder(@NonNull Type forType) {
        if (forType == null) {
            throw new NullPointerException("forType is marked non-null but is null");
        }
        this.forType = forType;
    }

    public static <X> ConfijBuilder<X> of(Class<X> forClass) {
        return new ConfijBuilder(forClass);
    }

    public static <X> ConfijBuilder<X> of(GenericType<X> forType) {
        List<ResolvedType> typeParameters = Util.TYPE_RESOLVER.resolve(forType.getClass(), new Type[0]).findSupertype(GenericType.class).getTypeParameters();
        if (typeParameters.size() != 1) {
            throw new IllegalArgumentException("expected 1 typeParameter, but got " + typeParameters);
        }
        return new ConfijBuilder(typeParameters.get(0));
    }

    public ConfijBuilder<T> loadFrom(ConfijSource ... source) {
        this.sources.addAll(Arrays.asList(source));
        return this;
    }

    public ConfijBuilder<T> loadFrom(String ... sourceStr) {
        return this.loadFrom((ConfijSource[])Stream.of(sourceStr).map(AnySourceImpl::new).toArray(AnySourceImpl[]::new));
    }

    public ConfijBuilder<T> loadFrom(ConfijResource ... resources) {
        return this.loadFrom((ConfijSource[])Stream.of(resources).map(FixResourceAnyFormatSource::new).toArray(FixResourceAnyFormatSource[]::new));
    }

    public ConfijBuilder<T> loadFrom(ConfijResource resource, ConfijFormat format) {
        return this.loadFrom(new FixResourceFixFormatSource(resource, format));
    }

    public ConfijBuilder<T> loadOptionalFrom(String ... maybeSourceStr) {
        return this.loadFrom((ConfijSource[])Stream.of(maybeSourceStr).map(AnySourceImpl::new).map(MaybeSource::new).toArray(MaybeSource[]::new));
    }

    public ConfijBuilder<T> loadFromFirstOf(String firstSource, String secondSource, String ... otherSources) {
        return this.loadFrom(new OrSource(new AnySourceImpl(firstSource), new AnySourceImpl(secondSource), (ConfijSource[])Stream.of(otherSources).map(AnySourceImpl::new).toArray(AnySourceImpl[]::new)));
    }

    public ConfijBuilder<T> validateOnlyWith(@NonNull ConfijValidator<T> validator) {
        if (validator == null) {
            throw new NullPointerException("validator is marked non-null but is null");
        }
        this.validator = validator;
        return this;
    }

    public ConfijBuilder<T> validationAllowsNull() {
        this.nonNullValidator = ConfijValidator.noopValidator();
        return this;
    }

    public ConfijBuilder<T> validationDisabled() {
        return this.validateOnlyWith(ConfijValidator.noopValidator());
    }

    public ConfijBuilder<T> templatingWith(@NonNull ValueResolver valueResolver) {
        if (valueResolver == null) {
            throw new NullPointerException("valueResolver is marked non-null but is null");
        }
        this.valueResolver = valueResolver;
        return this;
    }

    public ConfijBuilder<T> templatingDisabled() {
        return this.templatingWith(new NoopValueResolver());
    }

    public ConfijBuilder<T> bindValuesWith(ValueMapperFactory valueMapperFactory) {
        this.valueMapperFactories.add(0, valueMapperFactory);
        return this;
    }

    public <I> ConfijBuilder<T> bindValuesForClassWith(ValueMapperInstance<I> valueMapper, Class<I> forClass) {
        return this.bindValuesWith(ValueMapperFactory.forClass(valueMapper, forClass));
    }

    public ConfijBuilder<T> reloadStrategy(@NonNull ConfijReloadStrategy reloadStrategy) {
        if (reloadStrategy == null) {
            throw new NullPointerException("reloadStrategy is marked non-null but is null");
        }
        this.reloadStrategy = reloadStrategy;
        return this;
    }

    public ConfijBuilder<T> reloadPeriodically(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        return this.reloadStrategy(new PeriodicReloadStrategy(duration, duration));
    }

    @NonNull
    protected BindingContext newBindingContext() {
        return BindingContext.newDefaultContext(this.valueMapperFactories);
    }

    @NonNull
    protected NodeBindingContext newNodeBindingContext() {
        return NodeBindingContext.newDefaultSettings(this.valueResolver);
    }

    @NonNull
    protected ConfijPipeline<T> newPipeline() {
        ConfigBinder configBinder = new ConfigBinder();
        ConfigBinding<?> configBinding = configBinder.toRootConfigBinding(this.forType, this.newBindingContext());
        NodeDefinition nodeDefinition = configBinding.describe(this.newNodeBindingContext());
        return new ConfijPipelineImpl<T>(this.sources, new DefaultSource(), this.validator, configBinding, nodeDefinition, this.reloadNotifier);
    }

    public T build() {
        if (this.reloadStrategy != null && !(this.reloadStrategy instanceof NeverReloadStrategy)) {
            throw new ConfijException("there is an active ReloadStrategy configured ({}). however, by calling .build() there is no way to obtain an updated version of the configuration. use the .buildWrapper() instead and attach your reload hooks there.", this.reloadStrategy);
        }
        return this.buildWrapper().get();
    }

    public ConfijWrapper<T> buildWrapper() {
        this.lazySetDefaults();
        ConfijPipeline<T> pipeline = this.newPipeline();
        T initialConfig = pipeline.build();
        this.reloadStrategy.register(pipeline);
        return new ConfijWrapper<T>(initialConfig, this.reloadNotifier);
    }

    @Generated
    public String toString() {
        return "ConfijBuilder(forType=" + this.forType + ")";
    }

    public static final class ConfijWrapper<T> {
        private final AtomicReference<T> reference;
        private final ConfijReloadNotifier<T> reloadNotifier;

        public ConfijWrapper(T initialValue, ReloadNotifierImpl<T> reloadNotifier) {
            this.reference = new AtomicReference<T>(initialValue);
            this.reloadNotifier = reloadNotifier;
            reloadNotifier.registerRootReloadHandler(x -> this.reference.set(x.getNewValue()));
        }

        public T get() {
            return this.reference.get();
        }

        @Generated
        public ConfijReloadNotifier<T> getReloadNotifier() {
            return this.reloadNotifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfijWrapper)) {
                return false;
            }
            ConfijWrapper other = (ConfijWrapper)o;
            AtomicReference<T> this$reference = this.reference;
            AtomicReference<T> other$reference = other.reference;
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            ConfijReloadNotifier<T> this$reloadNotifier = this.getReloadNotifier();
            ConfijReloadNotifier<T> other$reloadNotifier = other.getReloadNotifier();
            return !(this$reloadNotifier == null ? other$reloadNotifier != null : !this$reloadNotifier.equals(other$reloadNotifier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicReference<T> $reference = this.reference;
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            ConfijReloadNotifier<T> $reloadNotifier = this.getReloadNotifier();
            result = result * 59 + ($reloadNotifier == null ? 43 : $reloadNotifier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfijBuilder.ConfijWrapper()";
        }
    }
}

