/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.binding.ConfijDefinitionException;
import ch.kk7.confij.binding.intf.IntfaceInvocationHandler;
import ch.kk7.confij.common.Util;
import ch.kk7.confij.shadow.com.fasterxml.classmate.MemberResolver;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import ch.kk7.confij.shadow.com.fasterxml.classmate.members.ResolvedMethod;
import ch.kk7.confij.shadow.com.fasterxml.classmate.types.ResolvedInterfaceType;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class InterfaceProxyBuilder<T> {
    private static final Map<Class<?>, Object> PRIMITIVE_ZEROS = Stream.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE).collect(Collectors.toMap(clazz -> clazz, clazz -> Array.get(Array.newInstance(clazz, 1), 0)));
    protected static final Comparator<Method> methodNameComparator = (Comparator & Serializable)(m1, m2) -> Comparator.comparing(Method::getName).compare((Method)m1, (Method)m2);
    private final ResolvedInterfaceType type;
    private final Set<ResolvedMethod> allowedMethods;
    private final Set<ResolvedMethod> mandatoryMethods;

    public InterfaceProxyBuilder(ResolvedInterfaceType type) {
        this.type = type;
        this.allowedMethods = this.supportedMethods(false);
        this.mandatoryMethods = this.supportedMethods(true);
    }

    protected static <T> T classToPrimitive(Class<T> primitiveClass) {
        return (T)PRIMITIVE_ZEROS.get(primitiveClass);
    }

    protected Set<ResolvedMethod> supportedMethods(boolean mandatoryOnly) {
        ResolvedMethod[] memberMethodsArr = this.supportedMemberResolver(mandatoryOnly).resolve(this.type, null, null).getMemberMethods();
        return Collections.unmodifiableSet(new HashSet<ResolvedMethod>(Arrays.asList(memberMethodsArr)));
    }

    protected MemberResolver supportedMemberResolver(boolean mandatoryOnly) {
        MemberResolver memberResolver = new MemberResolver(Util.TYPE_RESOLVER);
        memberResolver.setMethodFilter(method -> {
            if (Util.rawObjectType.equals(method.getDeclaringType())) {
                return false;
            }
            Method rawMethod = method.getRawMember();
            if (rawMethod.getParameterCount() != 0) {
                if (rawMethod.isDefault()) {
                    return false;
                }
                throw new ConfijDefinitionException("expected no-arg methods only in ConfiJ-interface, but found '{}'. Only default methods are allowed to have parameters.", method.getRawMember());
            }
            return !mandatoryOnly || !rawMethod.isDefault();
        });
        return memberResolver;
    }

    public ValidatingProxyBuilder builder() {
        return new ValidatingProxyBuilder();
    }

    @Generated
    public ResolvedInterfaceType getType() {
        return this.type;
    }

    @Generated
    public Set<ResolvedMethod> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Generated
    public Set<ResolvedMethod> getMandatoryMethods() {
        return this.mandatoryMethods;
    }

    @Generated
    public String toString() {
        return "InterfaceProxyBuilder(type=" + this.getType() + ", allowedMethods=" + this.getAllowedMethods() + ", mandatoryMethods=" + this.getMandatoryMethods() + ")";
    }

    public class ValidatingProxyBuilder {
        private final Map<ResolvedMethod, Object> methodToValues = new HashMap<ResolvedMethod, Object>();

        public ValidatingProxyBuilder methodToValue(ResolvedMethod resolvedMethod, Object value) {
            this.methodToValues.put(resolvedMethod, value);
            return this;
        }

        public T build() {
            Set<ResolvedMethod> inputMethods = this.methodToValues.keySet();
            HashSet<ResolvedMethod> notAllowedMethods = new HashSet<ResolvedMethod>(inputMethods);
            notAllowedMethods.removeAll(InterfaceProxyBuilder.this.allowedMethods);
            if (!notAllowedMethods.isEmpty()) {
                throw new ConfijBindingException("cannot create instance of type '{}' with methods {}. allowed are {}", InterfaceProxyBuilder.this.type, notAllowedMethods, InterfaceProxyBuilder.this.allowedMethods);
            }
            HashSet missingMandatoryMethods = new HashSet(InterfaceProxyBuilder.this.mandatoryMethods);
            missingMandatoryMethods.removeAll(inputMethods);
            if (!missingMandatoryMethods.isEmpty()) {
                throw new ConfijBindingException("cannot create instance of type '{}' due to missing mandatory methods {}", InterfaceProxyBuilder.this.type, missingMandatoryMethods);
            }
            TreeMap<Method, Object> fixedMethodToValue = new TreeMap<Method, Object>(methodNameComparator);
            this.methodToValues.forEach((method, value) -> {
                ResolvedType returnClass = method.getReturnType();
                if (value == null && returnClass.isPrimitive()) {
                    value = InterfaceProxyBuilder.classToPrimitive(returnClass.getErasedType());
                }
                fixedMethodToValue.put((Method)method.getRawMember(), value);
            });
            Class<?> forInterface = InterfaceProxyBuilder.this.type.getErasedType();
            IntfaceInvocationHandler invocationHandler = new IntfaceInvocationHandler(forInterface.getSimpleName(), fixedMethodToValue);
            return Proxy.newProxyInstance(forInterface.getClassLoader(), new Class[]{forInterface, ConfijHandled.class}, (InvocationHandler)invocationHandler);
        }
    }

    public static interface ConfijHandled {
        public Map<Method, Object> methodToValue();
    }
}

