/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.map;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.shadow.com.fasterxml.classmate.ResolvedType;
import ch.kk7.confij.shadow.com.fasterxml.classmate.members.RawConstructor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class MapBuilder {
    private final Supplier<Map> supplier;
    private final Function<Map, Map> hardener;

    public MapBuilder(ResolvedType type) {
        if (!type.isInstanceOf(Map.class)) {
            throw new IllegalArgumentException("expected a map type, but got " + type);
        }
        this.supplier = this.newMapSupplier(type);
        this.hardener = this.newMapHardener(type);
    }

    protected Supplier<Map> newMapSupplier(ResolvedType type) {
        if (type.isInterface()) {
            return this.interfaceSupplier(type);
        }
        return this.constructorSupplier(type);
    }

    protected Supplier<Map> interfaceSupplier(ResolvedType type) {
        Class<AbstractMap> intfClass = type.getErasedType();
        if (intfClass.isAssignableFrom(HashMap.class)) {
            return HashMap::new;
        }
        if (intfClass.isAssignableFrom(TreeMap.class)) {
            return TreeMap::new;
        }
        throw new ConfijBindingException("Attempting to bind to a Map of interface-type {}. However no supported implementation is known for this. Prefer Map directly.", type);
    }

    protected Supplier<Map> constructorSupplier(ResolvedType type) {
        Constructor constructor = type.getConstructors().stream().map(RawConstructor::getRawMember).filter(c -> c.getParameterCount() == 0).findAny().orElseThrow(() -> new ConfijBindingException("Attempted to bind to a Map of type {}. However this class doesn't provide a no-arg constructor. It's preferable to use a tree Map interface instead of concrete Map classes.", type));
        return () -> {
            try {
                return (Map)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ConfijBindingException("unable to call no-arg constructor on {}", type, e);
            }
        };
    }

    protected Function<Map, Map> newMapHardener(ResolvedType type) {
        Class<?> intfClass = type.getErasedType();
        if (Map.class.equals(intfClass)) {
            return x -> Collections.unmodifiableMap(x);
        }
        if (SortedMap.class.equals(intfClass)) {
            return x -> Collections.unmodifiableSortedMap((SortedMap)x);
        }
        if (NavigableMap.class.equals(intfClass)) {
            return x -> Collections.unmodifiableNavigableMap((NavigableMap)x);
        }
        return x -> x;
    }

    public <K, V> Map<K, V> newInstance() {
        return this.supplier.get();
    }

    public <K, V> Map<K, V> tryHarden(Map<K, V> collection) {
        return this.hardener.apply(collection);
    }

    @Generated
    public Supplier<Map> getSupplier() {
        return this.supplier;
    }

    @Generated
    public Function<Map, Map> getHardener() {
        return this.hardener;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapBuilder)) {
            return false;
        }
        MapBuilder other = (MapBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<Map> this$supplier = this.getSupplier();
        Supplier<Map> other$supplier = other.getSupplier();
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        Function<Map, Map> this$hardener = this.getHardener();
        Function<Map, Map> other$hardener = other.getHardener();
        return !(this$hardener == null ? other$hardener != null : !this$hardener.equals(other$hardener));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MapBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<Map> $supplier = this.getSupplier();
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        Function<Map, Map> $hardener = this.getHardener();
        result = result * 59 + ($hardener == null ? 43 : $hardener.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MapBuilder(supplier=" + this.getSupplier() + ", hardener=" + this.getHardener() + ")";
    }
}

