/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.any.ConfijAnyFormat;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.source.format.MapAndStringValidator;
import ch.kk7.confij.tree.ConfijNode;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class PropertiesFormat
implements ConfijFormat {
    private static final Pattern BRACKETS_ARRAY_FORMAT = Pattern.compile("(\\S+)\\[(\\d+)]");
    @NonNull
    private final String separator;
    private final String globalPrefix;

    public PropertiesFormat() {
        this(".", null);
    }

    public static PropertiesFormat withoutPrefix() {
        return new PropertiesFormat();
    }

    @Override
    public void override(ConfijNode rootNode, String configAsStr) {
        Properties properties = new Properties();
        try (StringReader r = new StringReader(configAsStr);){
            properties.load(r);
        }
        catch (IOException e) {
            throw ConfijSourceFormatException.invalidFormat("properties", "cannot load from string", e);
        }
        this.overrideWithProperties(rootNode, properties);
    }

    protected void overrideWithProperties(ConfijNode simpleConfig, Properties properties) {
        this.overrideWithFlatMap(simpleConfig, properties);
    }

    protected void overrideWithFlatMap(ConfijNode simpleConfig, Map<String, String> map) {
        Object deepMap = this.flatToNestedMapWithPrefix(map);
        this.overrideWithDeepMap(simpleConfig, deepMap);
    }

    protected void overrideWithDeepMap(ConfijNode node, Object deepMap) {
        MapAndStringValidator.validateDefinition(deepMap, node);
        ConfijNode newConfig = ConfijNode.newRootFor(node.getConfig()).initializeFromMap(deepMap);
        node.overrideWith(newConfig);
    }

    protected Object flatToNestedMapWithPrefix(Map<String, String> globalMap) {
        return this.flatToNestedMap(this.flatmapPrefixedBy(globalMap, this.getGlobalPrefix()));
    }

    protected Map<String, String> flatmapPrefixedBy(@NonNull Map<String, String> map, String prefix) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (prefix == null) {
            return map;
        }
        String prefixAndSep = prefix + this.getSeparator();
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> {
            if (k.startsWith(prefixAndSep)) {
                result.put(k.substring(prefixAndSep.length()), (String)v);
            }
        });
        return result;
    }

    @NonNull
    protected Object flatToNestedMap(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fullKey = entry.getKey();
            Map<String, Object> current = result;
            String[] keyParts = (String[])Arrays.stream(fullKey.split(Pattern.quote(this.getSeparator()), -1)).flatMap(currentKey -> {
                Matcher matcher = BRACKETS_ARRAY_FORMAT.matcher((CharSequence)currentKey);
                if (matcher.matches()) {
                    return Stream.of(matcher.group(1), matcher.group(2));
                }
                return Stream.of(currentKey);
            }).toArray(String[]::new);
            String keySoFar = null;
            for (int i = 0; i < keyParts.length - 1; ++i) {
                keySoFar = keySoFar == null ? keyParts[i] : keySoFar + this.getSeparator() + keyParts[i];
                Object child = current.computeIfAbsent(keyParts[i], s -> new HashMap());
                if (child instanceof String) {
                    throw this.keyConflict(fullKey, keySoFar);
                }
                current = (Map)child;
            }
            String lastKeyPart = keyParts[keyParts.length - 1];
            if (current.containsKey(lastKeyPart)) {
                throw this.keyConflict(fullKey, fullKey + this.getSeparator() + "*");
            }
            current.put(lastKeyPart, entry.getValue());
        }
        return result;
    }

    protected ConfijSourceFormatException keyConflict(String key1, String key2) {
        String prefixStr = this.getGlobalPrefix() == null ? "" : this.getGlobalPrefix() + this.getSeparator();
        return new ConfijSourceFormatException("key '{}' conflicts with key '{}'. each key must start with an unique string to map it into a config-tree structure.", prefixStr + key1, prefixStr + key2);
    }

    @NonNull
    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public String getGlobalPrefix() {
        return this.globalPrefix;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertiesFormat)) {
            return false;
        }
        PropertiesFormat other = (PropertiesFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        String this$globalPrefix = this.getGlobalPrefix();
        String other$globalPrefix = other.getGlobalPrefix();
        return !(this$globalPrefix == null ? other$globalPrefix != null : !this$globalPrefix.equals(other$globalPrefix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertiesFormat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        String $globalPrefix = this.getGlobalPrefix();
        result = result * 59 + ($globalPrefix == null ? 43 : $globalPrefix.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PropertiesFormat(separator=" + this.getSeparator() + ", globalPrefix=" + this.getGlobalPrefix() + ")";
    }

    @Generated
    public PropertiesFormat withSeparator(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        return this.separator == separator ? this : new PropertiesFormat(separator, this.globalPrefix);
    }

    @Generated
    public PropertiesFormat withGlobalPrefix(String globalPrefix) {
        return this.globalPrefix == globalPrefix ? this : new PropertiesFormat(this.separator, globalPrefix);
    }

    @Generated
    public PropertiesFormat(@NonNull String separator, String globalPrefix) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        this.separator = separator;
        this.globalPrefix = globalPrefix;
    }

    @AutoService(value={ConfijAnyFormat.class})
    public static class PropertiesAnyFormat
    implements ConfijAnyFormat {
        @Override
        public Optional<ConfijFormat> maybeHandle(String pathTemplate) {
            if (Util.getSchemeSpecificPart(pathTemplate).matches("(?s).+\\.prop(ertie)?s?$")) {
                return Optional.of(new PropertiesFormat());
            }
            return Optional.empty();
        }

        @Generated
        public String toString() {
            return "PropertiesFormat.PropertiesAnyFormat()";
        }
    }
}

