/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.collection;

import ch.kk7.confij.binding.ConfijDefinitionException;
import com.fasterxml.classmate.ResolvedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class CollectionBuilder {
    private final Supplier<Collection> supplier;
    private final Function<Collection, Collection> hardener;

    public CollectionBuilder(ResolvedType type) {
        this(CollectionBuilder.erasedCollectionType(type));
    }

    public CollectionBuilder(@NonNull Class<? extends Collection> collectionClass) {
        if (collectionClass == null) {
            throw new NullPointerException("collectionClass is marked non-null but is null");
        }
        this.supplier = this.newCollectionSupplier(collectionClass);
        this.hardener = this.newCollectionHardener(collectionClass);
    }

    protected static Class<? extends Collection> erasedCollectionType(ResolvedType type) {
        if (!type.isInstanceOf(Collection.class)) {
            throw new IllegalArgumentException("expected a collection type, but got " + type);
        }
        return type.getErasedType();
    }

    protected Supplier<Collection> newCollectionSupplier(Class<? extends Collection> collectionClass) {
        if (collectionClass.isInterface()) {
            return this.interfaceSupplier(collectionClass);
        }
        return this.constructorSupplier(collectionClass);
    }

    protected Supplier<Collection> interfaceSupplier(Class<? extends Collection> collectionClass) {
        if (collectionClass.isAssignableFrom(LinkedHashSet.class)) {
            return LinkedHashSet::new;
        }
        if (collectionClass.isAssignableFrom(ArrayList.class)) {
            return ArrayList::new;
        }
        if (collectionClass.isAssignableFrom(TreeSet.class)) {
            return TreeSet::new;
        }
        throw new ConfijDefinitionException("Attempting to bind to a Collection of interface-type {}. However no supported implementation is known for this. Prefer Set or List directly.", collectionClass);
    }

    protected Supplier<Collection> constructorSupplier(Class<? extends Collection> collectionClass) {
        Constructor constructor = Stream.of(collectionClass.getConstructors()).map(x -> x).filter(c -> c.getParameterCount() == 0).findAny().orElseThrow(() -> new ConfijDefinitionException("Attempted to bind to a Collection of type {}. However this class doesn't provide a no-arg constructor. It's preferable to use tree Set or List interfaces instead of concrete Collection classes.", collectionClass));
        return () -> {
            try {
                return (Collection)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ConfijDefinitionException("unable to call no-arg constructor on {}", collectionClass, e);
            }
        };
    }

    protected Function<Collection, Collection> newCollectionHardener(Class<? extends Collection> collectionClass) {
        if (Set.class.equals(collectionClass)) {
            return x -> Collections.unmodifiableSet((Set)x);
        }
        if (List.class.equals(collectionClass)) {
            return x -> Collections.unmodifiableList((List)x);
        }
        if (SortedSet.class.equals(collectionClass)) {
            return x -> Collections.unmodifiableSortedSet((SortedSet)x);
        }
        if (NavigableSet.class.equals(collectionClass)) {
            return x -> Collections.unmodifiableNavigableSet((NavigableSet)x);
        }
        return x -> x;
    }

    public <T> Collection<T> newInstance() {
        return this.supplier.get();
    }

    public <T> Collection<T> tryHarden(Collection<T> collection) {
        return this.hardener.apply(collection);
    }

    public <T> Collector<T, ?, Collection<T>> asCollector() {
        return Collectors.collectingAndThen(Collectors.toCollection(this::newInstance), this::tryHarden);
    }
}

